/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.exe4j.runtime.util.ResourceHelper;
import com.exe4j.runtime.util.WinDel;
import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MsiScope;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.platform.macos.MacAuthorization;
import com.install4j.runtime.installer.platform.win32.MsiCommunication;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.launcher.integration.gui.AwtAndFxWindowChecker;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPrivilegesAction
extends SystemInstallOrUninstallAction {
    private static boolean helperStarted = false;

    protected boolean startOnLinux(Context context) throws UserCanceledException {
        boolean usePkexec;
        boolean bl = usePkexec = context.isGui() || InstallerUtil.isUnattendedAlerts() || InstallerUtil.isUnattendedWithProgress();
        if (!usePkexec && context.isUnattended()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            return true;
        }
        if (!new File(moduleName).exists()) {
            Util.showMessage(Messages.format(Messages.getString(".ErrorInternal2"), "Could not start elevated: " + moduleName), 0);
            return false;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        ProcessBuilder.Redirect inputRedirect = ProcessBuilder.Redirect.PIPE;
        ArrayList<String> command = new ArrayList<String>();
        if (usePkexec) {
            command.add("pkexec");
            command.add("--disable-internal-agent");
            command.addAll(this.getMainCommand(context, moduleName, helperCommunication, identifier));
        } else {
            boolean useSudo;
            inputRedirect = ProcessBuilder.Redirect.INHERIT;
            boolean bl2 = useSudo = ConsoleImpl.getInstance().askOption(Messages.getString(".RootAuthorizationMethod"), new String[]{"sudo", "su"}, null, 0) == 0;
            if (useSudo) {
                command.add("sudo");
                command.addAll(this.getMainCommand(context, moduleName, helperCommunication, identifier));
            } else {
                command.add("su");
                command.add("-c");
                command.add(this.getMainCommand(context, moduleName, helperCommunication, identifier).stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(" ")));
            }
        }
        try {
            Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectInput(inputRedirect).start();
            if (process.waitFor(10L, TimeUnit.MINUTES)) {
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    Logger.getInstance().error(this, "Exit value of helper process is " + exitValue);
                } else {
                    helperStarted = helperCommunication.connect();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            Logger.getInstance().log(e);
            return false;
        }
        return helperStarted;
    }

    private List<String> getMainCommand(Context context, String moduleName, HelperCommunication helperCommunication, String identifier) {
        ArrayList<String> command = new ArrayList<String>();
        if (InstallerConfig.isInstaller()) {
            command.add("/bin/sh");
        }
        command.add(moduleName);
        command.add("__i4j_auth_restart");
        command.add(new File(System.getProperty("user.dir")).getAbsolutePath());
        command.add(new File(System.getProperty("java.home")).getAbsolutePath());
        if (Installer.getManualTempDir() != null) {
            command.add("-temp");
            command.add(Installer.getManualTempDir());
        }
        for (String argument : this.getCommonArguments(context, identifier, helperCommunication.getHash())) {
            command.add("-J" + argument);
        }
        return command;
    }

    protected boolean startOnMac(Context context) {
        if (!Util.isMacosInstaller()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        List<String> arguments = this.getJavaArguments(context, identifier, helperCommunication.getHash(), !InstallerUtil.isInProcess());
        String prompt = MacAuthorization.getDefaultPrompt(InstallerConfig.getCurrentInstance() == null ? null : InstallerConfig.getCurrentInstance().getApplicationName());
        try {
            MacAuthorization.execute(prompt, this.getJavaPath(), arguments);
            helperStarted = helperCommunication.connect();
        }
        catch (MacAuthorization.BaseAuthorizationException e) {
            Logger.getInstance().log(e);
        }
        return helperStarted;
    }

    @NotNull
    private String getJavaPath() {
        return new File(System.getProperty("java.home"), "bin/java").getAbsolutePath();
    }

    @NotNull
    private List<String> getJavaArguments(Context context, String identifier, String hash, boolean useCurrentClassPath) {
        String classPath = useCurrentClassPath ? System.getProperty("java.class.path") : new File(ResourceHelper.getRuntimeDir(), "i4jruntime.jar").getAbsolutePath();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-classpath");
        arguments.add(classPath);
        arguments.addAll(this.getCommonArguments(context, identifier, hash));
        if (System.getProperty("exe4j.moduleName") != null) {
            arguments.add("-Dexe4j.moduleName=" + System.getProperty("exe4j.moduleName"));
        }
        if (System.getProperty("i4j.jreBundle") != null) {
            arguments.add("-Di4j.jreBundle=" + System.getProperty("i4j.jreBundle"));
        }
        if (System.getProperty("i4j.tarFile") != null) {
            arguments.add("-Di4j.tarFile=" + System.getProperty("i4j.tarFile"));
        }
        if (System.getProperty("install4j.debugLaunch") != null) {
            arguments.add("-Dinstall4j.debugLaunch=" + System.getProperty("install4j.debugLaunch"));
        }
        if (System.getProperty("install4j.noSuid") != null) {
            arguments.add("-Dinstall4j.noSuid=" + System.getProperty("install4j.noSuid"));
        }
        arguments.add("-Dapple.awt.UIElement=true");
        arguments.add(HelperCommunication.class.getName());
        Logger.getInstance().info(null, "args: " + arguments);
        return arguments;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startOnWindows(Context context) {
        Window parentWindow = UiUtil.getParentWindow();
        if (parentWindow != null) {
            parentWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            boolean bl = this.startOnWindowsUnguarded(context);
            return bl;
        }
        finally {
            if (parentWindow != null) {
                parentWindow.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private boolean startOnWindowsUnguarded(Context context) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        if (helperStarted) {
            Util.logInfo(this, "Elevated helper process already started");
            return true;
        }
        if (MsiHelper.isStartedFromMsi()) {
            if (!MsiHelper.isMsiAllUsers(context) && MsiHelper.getMsiScope() == MsiScope.PER_USER) {
                Util.logInfo(this, "Elevation is not available in a per-user MSI scope");
                return false;
            }
            if (context.isUnattended()) {
                Util.logInfo(this, "Elevation is not available for MSI in unattended mode");
                return false;
            }
        }
        if (Win32UserInfo.isUACDisabled()) {
            return false;
        }
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            return true;
        }
        if (!new File(moduleName).exists()) {
            Util.logError(this, "Executable " + moduleName + " not found");
            Util.showMessage(Messages.format(Messages.getString(".ErrorInternal2"), "Could not start elevated: " + moduleName), 0);
            return false;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        Util.logInfo(this, "Starting elevated helper");
        SplashProgressInterface splashProgressInterface = this.checkSplashScreen(context);
        InstallerUtil.storeJreInfoForInstaller();
        String arguments = "__i4j_lang_restart" + (Installer.getManualTempDir() == null ? "" : " -temp \"" + Installer.getManualTempDir() + "\"") + AbstractPrivilegesAction.joinWithPrefix(this.getCommonArguments(context, identifier, helperCommunication.getHash())) + " -J-D" + "exe4j.unextractedPositionRestart" + "=" + Integer.getInteger("exe4j.unextractedPositionRestart", Integer.getInteger("exe4j.unextractedPosition", 0)) + " -J-D" + "install4j.dontUninstallServices" + "=" + Boolean.getBoolean("install4j.dontUninstallServices") + (WinDel.SEMAPHORE_NAME == null ? "" : " \"-J-Dexe4j.semaphoreName=" + WinDel.SEMAPHORE_NAME + "\"") + (System.getProperty("windel.logfile") == null ? "" : " \"-J-Dwindel.logfile=" + System.getProperty("windel.logfile") + "\"");
        if (MsiCommunication.isConnected()) {
            if (InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().getMsiScope() == MsiScope.PER_USER) {
                MsiCommunication.sendElevationRequested();
            } else {
                helperStarted = MsiCommunication.executeElevated(MsiHelper.addMsiArguments(arguments));
                if (helperStarted) {
                    MsiHelper.setMsiAllUsers(true);
                }
            }
        } else {
            helperStarted = Win32UserInfo.executeElevated(moduleName, arguments, System.getProperty("user.dir"));
        }
        boolean bl = helperStarted = helperStarted && helperCommunication.connect();
        if (helperStarted && !AbstractPrivilegesAction.checkFullAdminRights()) {
            Logger.getInstance().error(this, "The elevated helper does not have full admin rights");
            helperCommunication.terminate();
            helperStarted = false;
        }
        if (splashProgressInterface != null) {
            splashProgressInterface.setVisible(false);
        }
        return helperStarted;
    }

    private static String joinWithPrefix(List<String> arguments) {
        StringBuilder builder = new StringBuilder();
        for (String argument : arguments) {
            builder.append(" -J");
            builder.append(argument);
        }
        return builder.toString();
    }

    @NotNull
    private List<String> getCommonArguments(Context context, String identifier, String hash) {
        ArrayList<String> arguments = new ArrayList<String>();
        int debugPort = Integer.getInteger("install4j.helperDebugPort", 0);
        if (debugPort > 0) {
            arguments.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort);
        }
        arguments.add(System.getProperty("install4j.helperMaxHeap", "-Xmx128m"));
        arguments.add("-Duser.language=" + context.getLanguageId());
        arguments.add("-Dinstall4j.language=" + context.getLanguageId());
        arguments.add("-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage"));
        arguments.add("-Dinstall4j.commIdentifier=" + identifier);
        arguments.add("-Dinstall4j.commHash=" + hash);
        arguments.add("-Dinstall4j.helperAppId=" + InstallerConfig.getCurrentApplicationId());
        arguments.add("-Dinstall4j.helperLog=" + Boolean.getBoolean("install4j.helperLog"));
        arguments.add("-Dinstall4j.dontUninstallServices=" + Boolean.getBoolean("install4j.dontUninstallServices"));
        return arguments;
    }

    protected boolean setAdminRightsVariable() {
        boolean adminRights = Util.isAdminGroup() && Util.hasFullAdminRights() || HelperCommunication.getInstance().hasElevatedHelper();
        InstallerVariables.setAdminRightsFromPrivilegesAction(adminRights);
        return adminRights;
    }

    private static boolean checkFullAdminRights() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                return Util.hasFullAdminRights();
            }
        });
    }

    @Nullable
    private String getModuleName() {
        String moduleName;
        Application application = InstallerConfig.getCurrentApplication();
        if (application instanceof CustomApplication && !((CustomApplication)application).isCreateExecutable()) {
            Util.logError(this, "No elevation can be performed in a custom application without an executable.");
            return null;
        }
        if (InstallerUtil.isInProcess()) {
            File exeFile = com.install4j.runtime.installer.Application.getExeFile((ApplicationWithPath)application);
            if (exeFile != null) {
                moduleName = exeFile.getAbsolutePath();
            } else {
                moduleName = null;
                Util.logError(this, "Internal error: The executable of the custom application is null.");
            }
        } else {
            moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                Util.showMessage("No elevation can be performed for debug installers. Continuing without elevation.", 1);
            }
        }
        return moduleName;
    }

    private SplashProgressInterface checkSplashScreen(Context context) {
        SplashProgressInterface ret = null;
        if (!(InstallerConfig.isInstaller() && !((InstallerApplication)InstallerConfig.getCurrentApplication()).isSuppressProgressDialog() || context.isConsole() || context.isUnattended() || AwtAndFxWindowChecker.hasVisibleWindows())) {
            SplashProgressInterface splashProgressInterface;
            String title = "install4j";
            if (context.getWizardContext() instanceof WizardScreenExecutor) {
                title = ((WizardScreenExecutor)context.getWizardContext()).getWindowTitle();
            }
            ret = splashProgressInterface = new SplashProgressInterface(title, false, false, false, null, false, null);
            splashProgressInterface.setStatusMessage(Messages.getString(".ProcessElevationTitle"));
            try {
                Runnable runnable = () -> {
                    splashProgressInterface.setIndeterminateProgress(true);
                    splashProgressInterface.setVisible(true);
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected void showFailureMessage(Context context) throws UserCanceledException {
        String message = context instanceof InstallerContext ? (InstallerConfig.getCurrentApplication() instanceof InstallerApplication ? (Util.isWindows() ? Messages.getString(".AdminPrivilegesRequired") : Messages.getString(".RootPrivilegesRequired")) : (Util.isWindows() ? Messages.getString(".AdminPrivilegesRequiredExecute") : Messages.getString(".RootPrivilegesRequiredExecute"))) : Messages.getString(".OnlyAdminCanUninstall");
        Util.showMessage(message, 0);
        throw new UserCanceledException("not admin");
    }

    private String getHelperDebugArgument(String prefix, boolean withSpace) {
        int debugPort = Integer.getInteger("install4j.helperDebugPort", 0);
        if (debugPort > 0) {
            return (withSpace ? " " : "") + prefix + "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPort;
        }
        return "";
    }
}

