/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.misc.MacosVmOptionsType;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class AbstractModifyVmOptionsAction
extends SystemInstallAction {
    private String launcherId = "";
    private MacosVmOptionsType macosVmOptionsType = MacosVmOptionsType.INNER;
    private static final String[] REPLACE_OPTION_PREFIXES = new String[]{"-Xmx", "-Xms", "-Xss", "-Xloggc:", "-Xbootclasspath:", "-Xbootclasspath/a:", "-Xbootclasspath/p:", "-verbose:", "-ea:", "-da:", "-enableassertions:", "-disableassertions:", "-splash:", "-classpath ", "-classpath/a ", "-classpath/p "};

    protected abstract String[] getAddVmOptions();

    public String getLauncherId() {
        return AbstractModifyVmOptionsAction.replaceVariables(this.launcherId);
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public MacosVmOptionsType getMacosVmOptionsType() {
        return this.replaceWithTextOverride("macosVmOptionsType", this.macosVmOptionsType, MacosVmOptionsType.class);
    }

    public void setMacosVmOptionsType(MacosVmOptionsType macosVmOptionsType) {
        this.macosVmOptionsType = macosVmOptionsType;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        File launcherFile = null;
        ContextImpl.LauncherSetupImpl launcherSetup = (ContextImpl.LauncherSetupImpl)context.getLauncherById(this.getLauncherId());
        if (launcherSetup != null) {
            MacSpecificConfig macSpecificConfig = InstallerConfig.getCurrentInstance().getMacSpecificConfig();
            launcherFile = Util.isMacosInstaller() && macSpecificConfig.isSingleBundle() && Objects.equals(launcherSetup.getInternalId(), macSpecificConfig.getSingleBundleLauncherId()) ? context.getDestinationFile(macSpecificConfig.getSingleBundleName()) : context.getDestinationFile(launcherSetup.getRelativeFileName());
        }
        if (launcherFile == null || !launcherFile.exists()) {
            Logger.getInstance().error(this, "launcher file " + launcherFile + " does not exist.");
            return false;
        }
        try {
            if (launcherFile.isDirectory()) {
                File vmOptionsFile = this.getMacosVmOptionsType() == MacosVmOptionsType.OUTER ? new File(launcherFile.getParentFile(), launcherFile.getName().replace(".app", "") + ".vmoptions") : new File(launcherFile, "Contents/vmoptions.txt");
                return this.modifyVmOptions(vmOptionsFile, context);
            }
            String vmOptionsPath = launcherFile.getAbsolutePath();
            if (vmOptionsPath.endsWith(".exe")) {
                vmOptionsPath = vmOptionsPath.substring(0, vmOptionsPath.length() - 4);
            }
            vmOptionsPath = vmOptionsPath + ".vmoptions";
            return this.modifyVmOptions(new File(vmOptionsPath), context);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    private boolean modifyVmOptions(File vmOptionsFile, InstallerContext context) throws IOException, UserCanceledException {
        if (!vmOptionsFile.exists()) {
            FileInstaller.getInstance().registerUninstallFile(vmOptionsFile);
        } else {
            BackupFileForRollbackAction backupAction = new BackupFileForRollbackAction(vmOptionsFile, false);
            backupAction.install(context);
            this.addRollbackAction(backupAction);
        }
        List<String> oldVmOptions = AbstractModifyVmOptionsAction.readVmOptions(vmOptionsFile);
        List<String> newVmOptions = AbstractModifyVmOptionsAction.addVmOptions(oldVmOptions, new ArrayList<String>(Arrays.asList(this.getAddVmOptions())));
        AbstractModifyVmOptionsAction.writeFile(vmOptionsFile, newVmOptions);
        return true;
    }

    private static void writeFile(final File vmOptionsFile, final List<String> newVmOptions) {
        HelperCommunication.getInstance().executeAction(ContentInstaller.getExecutionContext(), new RunAction(){

            @Override
            protected void run(Context context) throws Exception {
                PrintWriter pw = Util.isMacOS() ? new PrintWriter(vmOptionsFile, StandardCharsets.UTF_8.name()) : new PrintWriter(vmOptionsFile);
                for (String newVmOption : newVmOptions) {
                    pw.println(newVmOption);
                }
                pw.close();
            }
        });
    }

    private static List<String> addVmOptions(List<String> oldVmOptions, List<String> addVmOptions) {
        ArrayList<String> newOptions = new ArrayList<String>();
        for (String oldVmOption : oldVmOptions) {
            String option = oldVmOption.trim();
            addVmOptions.remove(option);
            if (option.startsWith("-D")) {
                option = AbstractModifyVmOptionsAction.findReplaceOption(addVmOptions, AbstractModifyVmOptionsAction.getParameterPrefix(option), option);
            } else {
                for (String replaceOptionPrefix : REPLACE_OPTION_PREFIXES) {
                    if (!option.startsWith(replaceOptionPrefix)) continue;
                    option = AbstractModifyVmOptionsAction.findReplaceOption(addVmOptions, replaceOptionPrefix, option);
                }
            }
            newOptions.add(option);
        }
        newOptions.addAll(addVmOptions);
        return newOptions;
    }

    private static String getParameterPrefix(String option) {
        int equalPos = option.indexOf(61);
        if (equalPos > -1) {
            return option.substring(0, equalPos + 1);
        }
        return option;
    }

    private static String findReplaceOption(List<String> addVmOptions, String prefix, String oldOption) {
        Iterator<String> iterator = addVmOptions.iterator();
        while (iterator.hasNext()) {
            String option = iterator.next();
            if (!option.trim().startsWith(prefix)) continue;
            iterator.remove();
            return option;
        }
        return oldOption;
    }

    private static List<String> readVmOptions(File vmOptionsFile) throws IOException {
        ArrayList<String> vmOptions = new ArrayList<String>();
        if (vmOptionsFile.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(vmOptionsFile));
            String line = reader.readLine();
            while (line != null) {
                vmOptions.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        return vmOptions;
    }
}

