/*
 * Decompiled with CFR 0.152.
 */
package org.cisecurity.wrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public class OutputDeflector {
    private PrintStream originalErrorStream = null;
    private final PipedInputStream customPipedErrorStream = new PipedInputStream();
    private PrintStream customErrorStream = null;

    public void captureStandardError() throws IOException {
        this.originalErrorStream = System.err;
        this.customErrorStream = new PrintStream(new PipedOutputStream(this.customPipedErrorStream));
        System.setErr(this.customErrorStream);
    }

    public void releaseStandardError() {
        System.setErr(this.originalErrorStream);
        this.customErrorStream.close();
    }

    public String deflectedOutput() throws IOException {
        String line;
        StringBuilder output = new StringBuilder();
        BufferedReader customErrorReader = new BufferedReader(new InputStreamReader(this.customPipedErrorStream));
        while ((line = customErrorReader.readLine()) != null) {
            output = new StringBuilder(output + line + "\n");
        }
        return output.toString();
    }
}

