
/**
* Can get the ID of the button controlling
* a collapseable box by concatenating
* this string onto the ID of the box itself.
*/
var B_SFIX = "_button";

/**
* Returns an element in the current HTML document.
*
* @param elementID Identifier of HTML element
* @return               HTML element object
*/
function getElementObject(elementID) {
    var elemObj = null;
    if (document.getElementById) {
        elemObj = document.getElementById(elementID);
    }
    return elemObj;
}

/**
* Closes a collapseable box.
*
* @param boxObj       Collapseable box
* @param buttonObj Button controlling box
*/
function closeBox(boxObj, buttonObj) {
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else {
        // Change 'display' CSS property of box
        boxObj.style.display = "none";
        
        // Change text of button
        if (boxObj.style.display == "none") {
            buttonObj.value = "+";
            buttonObj.innerHTML = "Show";
        }
    }
}

/**
* Closes a collapseable box.
*
* @param boxObj       Collapseable box
* @param buttonObj Button controlling box
*/
function closeBoxML(boxObj, buttonObj) {
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else {
        // Change 'display' CSS property of box
        boxObj.style.display = "none";
        
        // Change text of button
        if (boxObj.style.display == "none") {
            buttonObj.value = "+";
            buttonObj.innerHTML = "More";
        }
    }
}

/**
* Opens a collapseable box.
*
* @param boxObj       Collapseable box
* @param buttonObj Button controlling box
*/
function openBox(boxObj, buttonObj) {
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else {
        // Change 'display' CSS property of box
        boxObj.style.display = "block";
        
        // Change text of button
        if (boxObj.style.display == "block") {
            buttonObj.value = "-";
            buttonObj.innerHTML = "Hide";
        }
    }
}

/**
* Opens a collapseable box.
*
* @param boxObj       Collapseable box
* @param buttonObj Button controlling box
*/
function openBoxML(boxObj, buttonObj) {
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else {
        // Change 'display' CSS property of box
        boxObj.style.display = "block";
        
        // Change text of button
        if (boxObj.style.display == "block") {
            buttonObj.value = "-";
            buttonObj.innerHTML = "Less";
        }
    }
}

/**
* Sets the state of a collapseable box.
*
* @param boxID Identifier of box
* @param open If true, box is "opened",
*             Otherwise, box is "closed".
*/
function setState(boxID, open) {
    var boxObj = getElementObject(boxID);
    var buttonObj = getElementObject(boxID + B_SFIX);
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else if (open) {
        openBox(boxObj, buttonObj);
        // Make button visible
        buttonObj.style.display = "inline";
    } else {
        closeBox(boxObj, buttonObj);
        // Make button visible
        buttonObj.style.display = "inline";
    }
}

/**
* Sets the state of a collapseable box.
*
* @param boxID Identifier of box
* @param open If true, box is "opened",
*             Otherwise, box is "closed".
*/
function setStateML(boxID, open) {
    var boxObj = getElementObject(boxID);
    var buttonObj = getElementObject(boxID + B_SFIX);
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else if (open) {
        openBoxML(boxObj, buttonObj);
        // Make button visible
        buttonObj.style.display = "inline";
    } else {
        closeBoxML(boxObj, buttonObj);
        // Make button visible
        buttonObj.style.display = "inline";
    }
}

/**
* Switches the state of a collapseable box, e.g.
* if it's opened, it'll be closed, and vice versa.
*
* @param boxID Identifier of box
*/
function switchState(boxID) {
    var boxObj = getElementObject(boxID);
    var buttonObj = getElementObject(boxID + B_SFIX);
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else if (boxObj.style.display == "none" || boxObj.style.display == "") {
        // Box is closed, so open it
        openBox(boxObj, buttonObj);
    } else if (boxObj.style.display == "block") {
        // Box is opened, so close it
        closeBox(boxObj, buttonObj);
    }
}

/**
* Switches the state of a collapseable box, e.g.
* if it's opened, it'll be closed, and vice versa.
*
* @param boxID Identifier of box
*/
function switchStateML(boxID) {
    var boxObj = getElementObject(boxID);
    var buttonObj = getElementObject(boxID + B_SFIX);
    if (boxObj == null || buttonObj == null) {
        // Box or button not found
    } else if (boxObj.style.display == "none" || boxObj.style.display == "") {
        // Box is closed, so open it
        openBoxML(boxObj, buttonObj);
    } else if (boxObj.style.display == "block") {
        // Box is opened, so close it
        closeBoxML(boxObj, buttonObj);
    }
}

/**
* Closes all boxes in a given list.
*
* @param boxList Array of box IDs
*/
function collapseAll(boxList) {
    var idx;
    for (idx = 0; idx < boxList.length; idx++) {
        var boxObj = getElementObject(boxList[idx]);
        var buttonObj = getElementObject(boxList[idx] + B_SFIX);
        closeBox(boxObj, buttonObj);
    }
}

/**
* Open all boxes in a given list.
*
* @param boxList Array of box IDs
*/
function expandAll(boxList) {
    var idx;
    for (idx = 0; idx < boxList.length; idx++) {
        var boxObj = getElementObject(boxList[idx]);
        var buttonObj = getElementObject(boxList[idx] + B_SFIX);
        openBox(boxObj, buttonObj);
    }
}

/**
* Makes all the control buttons of boxes appear.
*
* @param boxList Array of box IDs
*/
function viewControlButtons(boxList) {
    var idx;
    for (idx = 0; idx < boxList.length; idx++) {
        buttonObj = getElementObject(boxList[idx] + B_SFIX);
        if (buttonObj != null) {
            buttonObj.style.display = "inline";
        }
    }
}

/**
* Makes all the control buttons of boxes disappear.
*
* @param boxList Array of box IDs
*/
function hideControlButtons(boxList) {
    var idx;
    for (idx = 0; idx < boxList.length; idx++) {
        buttonObj = getElementObject(boxList[idx] + B_SFIX);
        if (buttonObj != null) {
            buttonObj.style.display = "none";
        }
    }
}

function toggleHygieneMoreLink() {
    var link = document.getElementById("moreLessLink")
    if (link.innerHTML == "More") {
        document.getElementById("hygieneMoreInfoDiv").style = "visibility: visible; float: left;"
        document.getElementById("moreLessLink").innerHTML = "Less"
    } else if (link.innerHTML == "Less") {
        document.getElementById("hygieneMoreInfoDiv").style = "display: none; float: left;"
        document.getElementById("moreLessLink").innerHTML = "More"
    }
}

function checkboxToggled() {
    var failuresOnlyCheckbox = document.getElementById("failuresOnlyCheckbox")
    var essentialHygieneCheckbox = document.getElementById("essentialHygieneCheckbox")
    var showNoControls8Message

    if (!failuresOnlyCheckbox.checked && !essentialHygieneCheckbox.checked) {
        displayPassAreas()
        showNonEssentialHygiene()
    } else if (failuresOnlyCheckbox.checked && essentialHygieneCheckbox.checked) {
        hidePassAreas()
        hideNonEssentialHygiene()
    } else if (failuresOnlyCheckbox.checked && !essentialHygieneCheckbox.checked) {
        showNonEssentialHygiene()
        hidePassAreas()
    } else if (!failuresOnlyCheckbox.checked && essentialHygieneCheckbox.checked) {
        displayPassAreas()
        hideNonEssentialHygiene()
    }
}

function showNonEssentialHygiene() {
    handleUncheckedDisplay("nonCriticalControlArea", "hidden", "visible");
    handleUncheckedDisplay("nonCriticalControlArea", "tableHidden", "tableVisible");
}

function hideNonEssentialHygiene() {
    handleUncheckedDisplay("nonCriticalControlArea", "visible", "hidden");
    handleUncheckedDisplay("nonCriticalControlArea", "tableVisible", "tableHidden");
}

/******** WKM *************/
/**
* Makes all of the pass results disappear -- effectively shows only failures
*/
function hidePassAreas() {
    handleUncheckedDisplay("nonFailureArea", "visible", "hidden");
    handleUncheckedDisplay("nonFailureArea", "tableVisible", "tableHidden");
    return false;
}

/**
* Makes all of the pass results show up -- effectively shows all results
*/
function displayPassAreas() {
    handleUncheckedDisplay("nonFailureArea", "hidden", "visible");
    handleUncheckedDisplay("nonFailureArea", "tableHidden", "tableVisible");
    return false;
}
/******** WKM *************/


/**
* Makes all of the not selected results disappear
*/
function hideUncheckedAreas() {
    handleUncheckedDisplay("notSelectedArea", "visible", "hidden");
    handleUncheckedDisplay("notSelectedArea", "tableVisible", "tableHidden");
    for (i = 0; i < document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a").length; i++) {
        if (document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a")[i].href != "") {
            document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a")[i].onclick = displayUncheckedAreas;
            document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a")[i].innerHTML = "Display All Defined Tests";
        }
    }
    return false;
}

/**
* Makes all of the not selected results show up
*/
function displayUncheckedAreas() {
    handleUncheckedDisplay("notSelectedArea", "hidden", "visible");
    handleUncheckedDisplay("notSelectedArea", "tableHidden", "tableVisible");
    for (i = 0; i < document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a").length; i++) {
        if (document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a")[i].href != "") {
            document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a")[i].onclick = hideUncheckedAreas;
            document.getElementById("toggleUncheckedItemsArea").getElementsByTagName("a")[i].innerHTML = "Show Applicable Tests Only";
        }
    }
    return false;
}

/**
* This function handles the work of displaying or hiding all of the not selected rules.
*
* @param displayArea - The class denoting the display area
* @param valueToLookFor - The class we want to look for (hidden or visible)
* @param valueToSetTo - The class we want to swap out
*/
function handleUncheckedDisplay(displayArea, valueToLookFor, valueToSetTo) {
    var checklistTable = document.getElementById("assessmentResultTable");
    for (i = 0; i < checklistTable.rows.length; i++) {
        var classValue = checklistTable.rows[i].className;
        if ((classValue.indexOf(displayArea) >= 0) &&
        (classValue.indexOf(valueToLookFor) >= 0)) {
            
            classValue = classValue.replace(valueToLookFor, valueToSetTo);
            checklistTable.rows[i].className = classValue;
        }
    }
    
    var results = document.getElementById("assessmentDetailsArea").getElementsByTagName('div');
    for (i = 0; i < results.length; i++) {
        var classValue = results[i].className;
        if ((classValue.indexOf(displayArea) >= 0) &&
        (classValue.indexOf(valueToLookFor) >= 0)) {
            
            classValue = classValue.replace(valueToLookFor, valueToSetTo);
            
            results[i].className = classValue;
        }
    }
}

document.addEventListener('DOMContentLoaded', function() {
    var modifiedRowCount = 0;
    var actualRowCount = 0;
    var checklistTable = document.getElementById("assessmentResultTable");
    var displayArea = "nonCriticalControlArea"
    for (i = 0; i < checklistTable.rows.length; i++) {
        var classValue = checklistTable.rows[i].className;
        if (classValue.length > 0) {
            actualRowCount++
        }
        if (classValue.indexOf(displayArea) >= 0)  {
            modifiedRowCount++
        }
    }
    // We are hiding only things that are not IG-1. So, if we hide everything, there's no controls 8.
    if (actualRowCount === modifiedRowCount) {
        var noControls8MessageDiv = document.getElementById("noControls8Div")
        noControls8MessageDiv.style = "visibility: visible; float: left;"
        document.getElementById("essentialHygieneCheckbox").disabled = true
    }
});


// -->
