#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   07/05/22   Check user home directory owner

output=""
valid_shells="^($( sed -rn '/^\//{s,/,\\\\/,g;p}' /etc/shells | paste -s -d '|' - ))$"
awk -v pat="$valid_shells" -F: '$(NF) ~ pat { print $1 " " $(NF-1) }' /etc/passwd | (while read -r user home; do
	owner="$(stat -L -c "%U" "$home")"
	[ "$owner" != "$user" ] && output="$output\n  - User \"$user\" home directory \"$home\" is owned by user \"$owner\""
done

# If the tests produce no output, we pass
if [ -z "$output" ]; then
   echo -e "\n-PASSED: - All local interactive users have a home directory\n"
   exit "${XCCDF_RESULT_PASS:-101}"
else
   echo -e "\n- FAILED:\n$output\n"
	exit "${XCCDF_RESULT_FAIL:-102}"
fi
)