#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   07/01/22   Check user dot files existence

output=""
fname="$XCCDF_VALUE_REGEX"
valid_shells="^($( sed -rn '/^\//{s,/,\\\\/,g;p}' /etc/shells | paste -s -d '|' - ))$"
awk -v pat="$valid_shells" -F: '$(NF) ~ pat { print $1 " " $(NF-1) }' /etc/passwd | (while read -r user home; do
	[ -f "$home/$fname" ] && output="$output\n  - User \"$user\" file: \"$home/$fname\" exists"
done

# If the tests produce no output, we pass
if [ -z "$output" ]; then
	echo -e "\n-PASSED: - No local interactive users have \"$fname\" files in their home directory\n"
	exit "${XCCDF_RESULT_PASS:-101}"
else
	echo -e "\n- FAILED:\n$output\n"
	exit "${XCCDF_RESULT_FAIL:-102}"
fi
)