#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   07/01/22   Check user home directories permissions (mode)

output=""
perm_mask="$XCCDF_VALUE_REGEX"
maxperm="$( printf '%o' $(( 0777 & ~$perm_mask)) )"
valid_shells="^($( sed -rn '/^\//{s,/,\\\\/,g;p}' /etc/shells | paste -s -d '|' - ))$"
awk -v pat="$valid_shells" -F: '$(NF) ~ pat { print $1 " " $(NF-1) }' /etc/passwd | (while read -r user home; do
	if [ -d "$home" ]; then
		mode=$( stat -L -c '%#a' "$home" )
		[ $(( "$mode" & "$perm_mask" )) -gt 0 ] && output="$output\n- User $user home directory: \"$home\" is too permissive: \"$mode\" (should be: \"$maxperm\" or more restrictive)"
	fi
done
# If the tests produce no output, we pass
if [ -z "$output" ]; then
	echo -e "\n- Passed:\n- All user home directories are mode: \"$maxperm\" or more restrictive"
	exit "${XCCDF_RESULT_PASS:-101}"
else
	echo -e "\n- Failed:$output"
	exit "${XCCDF_RESULT_FAIL:-102}"
fi
)