#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   07/01/22   Check user dot files permissions (mode)

output=""
perm_mask="$XCCDF_VALUE_REGEX"
maxperm="$( printf '%o' $(( 0777 & ~$perm_mask)) )"
valid_shells="^($( sed -rn '/^\//{s,/,\\\\/,g;p}' /etc/shells | paste -s -d '|' - ))$"
awk -v pat="$valid_shells" -F: '$(NF) ~ pat { print $1 " " $(NF-1) }' /etc/passwd | (while read -r user home; do
	for dfile in $(find "$home" -type f -name '.*'); do
		mode=$( stat -L -c '%#a' "$dfile" )
		[ $(( "$mode" & "$perm_mask" )) -gt 0 ] && output="$output\n- User $user file: \"$dfile\" is too permissive: \"$mode\" (should be: \"$maxperm\" or more restrictive)"
	done
done
# If the tests produce no output, we pass
if [ -z "$output" ]; then
	echo -e "\n- Passed:\n- All user dot files are mode: \"$maxperm\" or more restrictive"
	exit "${XCCDF_RESULT_PASS:-101}"
else
	echo -e "\n- Failed:$output"
	exit "${XCCDF_RESULT_FAIL:-102}"
fi
)