#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   07/13/22   openSSH private key file mode/owner/group check


l_output=""
l_skgn="ssh_keys" # Group designated to own openSSH keys
l_skgid="$(awk -F: '($1 == "'"$l_skgn"'"){print $3}' /etc/group)"
awk '{print}' <<< "$(find /etc/ssh -xdev -type f -name 'ssh_host_*_key' -exec stat -L -c "%n %#a %U %G %g" {} +)" | (while read -r  l_file l_mode l_owner l_group l_gid; do
	[ -n "$l_skgid" ] && l_cga="$l_skgn" || l_cga="root"
	[ "$l_gid" = "$l_skgid" ] && l_pmask="0137" || l_pmask="0177"
	l_maxperm="$( printf '%o' $(( 0777 & ~$l_pmask )) )"
	[ $(( $l_mode & $l_pmask )) -gt 0 ] && l_output="$l_output\n - File: \"$l_file\" is mode \"$l_mode\" should be mode: \"$l_maxperm\" or more restrictive"
	[ "$l_owner" != "root" ] && l_output="$l_output\n - File: \"$l_file\" is owned by: \"$l_owner\" should be owned by \"root\""
	if [ "$l_group" != "root" ] && [ "$l_gid" != "$l_skgid" ]; then
		l_output="$l_output\n - File: \"$l_file\" is owned by group \"$l_group\" should belong to group \"$l_cga\""
	fi
done
# If the an audit failed, l_output would have content. if not, we pass
if [ -z "$l_output" ]; then
	echo -e "\n- Audit Result:\n  *** PASS ***\n"
	exit "${XCCDF_RESULT_PASS:-101}"
else
   # print the reason why we are failing
	echo -e "\n- Audit Result:\n  *** FAIL ***$l_output\n"
	exit "${XCCDF_RESULT_FAIL:-102}"
fi
)

# If the regex matched, output would be generated.  If so, we pass
if [ -z "$output" ] ; then
	echo -e "PASS:\nAll listening ports have a firewall rule"
	exit "${XCCDF_RESULT_PASS:-101}"
else
    # print the reason why we are failing
	echo -e "FAIL:\n$output"
	exit "${XCCDF_RESULT_FAIL:-102}"
fi