#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   05/12/22   Check that audit log files are not read or write-accessible by unauthorized users

{
	echo "- Start check - Only authorized users own audit log files"
	output=""
	output="$(stat -Lc "%n %U" "$(dirname "$(awk -F"=" '/^\s*log_file/ {print $2}' /etc/audit/auditd.conf | xargs)")"/* | grep -Pv -- '^\H+\h+root\b')"
	
	# If all files passed, then we pass
	if [ -z "$output" ]; then
		echo -e "- PASS\n- All audit log files are owned by the root user"
		echo -e "- End check - Only authorized users own audit log files"
		exit "${XCCDF_RESULT_PASS:-101}"
	else
		# print the reason why we are failing
		echo -e "- FAIL:"
		echo -e "$output" | while read -r fileown; do
			echo "- File: \"$(awk '{print $1}' <<< "$fileown")\" is owned by: \"$(awk '{print $2}' <<< "$fileown")\""
		done
		echo -e "- End check - Only authorized users own audit log files"
		exit "${XCCDF_RESULT_FAIL:-102}"
	fi
}
