#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   03/10/21   Check logfiles have appropriate permissions and ownership
	
{
	echo "- Start check - logfiles have appropriate permissions and ownership"
	output=""
	find /var/log -type f | (while read -r fname; do
		bname="$(basename "$fname")"
		case "$bname" in
			lastlog | lastlog.* | wtmp | wtmp.* | btmp | btmp.*)
				! stat -Lc "%a" "$fname" | grep -Pq -- '^\h*[0,2,4,6][0,2,4,6][0,4]\h*$' && output="$output\n- File: \"$fname\" mode: \"$(stat -Lc "%a" "$fname")\"\n"
				! stat -Lc "%U %G" "$fname" | grep -Pq -- '^\h*root\h+(utmp|root)\h*$' && output="$output\n- File: \"$fname\" ownership: \"$(stat -Lc "%U:%G" "$fname")\"\n"
				;;
			secure | auth.log)
				! stat -Lc "%a" "$fname" | grep -Pq -- '^\h*[0,2,4,6][0,4]0\h*$' && output="$output\n- File: \"$fname\" mode: \"$(stat -Lc "%a" "$fname")\"\n"
				! stat -Lc "%U %G" "$fname" | grep -Pq -- '^\h*(syslog|root)\h+(adm|root)\h*$' && output="$output\n- File: \"$fname\" ownership: \"$(stat -Lc "%U:%G" "$fname")\"\n"
				;;
			SSSD | sssd)
				! stat -Lc "%a" "$fname" | grep -Pq -- '^\h*[0,2,4,6][0,2,4,6]0\h*$' && output="$output\n- File: \"$fname\" mode: \"$(stat -Lc "%a" "$fname")\"\n"
				! stat -Lc "%U %G" "$fname" | grep -Piq -- '^\h*(SSSD|root)\h+(SSSD|root)\h*$' && output="$output\n- File: \"$fname\" ownership: \"$(stat -Lc "%U:%G" "$fname")\"\n"
				;;
			gdm | gdm3)
				! stat -Lc "%a" "$fname" | grep -Pq -- '^\h*[0,2,4,6][0,2,4,6]0\h*$' && output="$output\n- File: \"$fname\" mode: \"$(stat -Lc "%a" "$fname")\"\n"
				! stat -Lc "%U %G" "$fname" | grep -Pq -- '^\h*(root)\h+(gdm3?|root)\h*$' && output="$output\n- File: \"$fname\" ownership: \"$(stat -Lc "%U:%G" "$fname")\"\n"
				;;
			*.journal)
				! stat -Lc "%a" "$fname" | grep -Pq -- '^\h*[0,2,4,6][0,4]0\h*$' && output="$output\n- File: \"$fname\" mode: \"$(stat -Lc "%a" "$fname")\"\n"
				! stat -Lc "%U %G" "$fname" | grep -Pq -- '^\h*(root)\h+(systemd-journal|root)\h*$' && output="$output\n- File: \"$fname\" ownership: \"$(stat -Lc "%U:%G" "$fname")\"\n"
				;;
			*)
				! stat -Lc "%a" "$fname" | grep -Pq -- '^\h*[0,2,4,6][0,4]0\h*$' && output="$output\n- File: \"$fname\" mode: \"$(stat -Lc "%a" "$fname")\"\n"
				! stat -Lc "%U %G" "$fname" | grep -Pq -- '^\h*(syslog|root)\h+(adm|root)\h*$' && output="$output\n- File: \"$fname\" ownership: \"$(stat -Lc "%U:%G" "$fname")\"\n"
				;;
		esac
	done
	# If all files passed, then we pass
	if [ -z "$output" ]; then
		echo -e "\n- PASS\n- All files in \"/var/log/\" have appropriate permissions and ownership"
		echo -e "- End check - logfiles have appropriate permissions and ownership"
		exit "${XCCDF_RESULT_PASS:-101}"
	else
		# print the reason why we are failing
		echo -e "\n- FAIL:\n$output"
		echo -e "- End check - logfiles have appropriate permissions and ownership"
		exit "${XCCDF_RESULT_FAIL:-102}"
	fi
	)
}