#!/usr/bin/env bash

#
# CIS-CAT Script Check Engine
#
# Name         Date       Description
# -------------------------------------------------------------------
# E. Pinnell   05/12/22   Check that only authorized groups are assigned ownership of audit log files

{
   echo "- Start check - Only authorized groups assigned ownership audit log files"
   output="" output2="" tst=""
   output="$(grep -Piw -- '^\h*log_group\h*=\h*\H+\b' /etc/audit/auditd.conf)"
   grep -Pq '^\h*log_group\h*=\h*(adm|root)\b' <<< "$output" && tst="pass"
   output2="$(stat -c "%n %G" "$(dirname "$(awk -F"=" '/^\s*log_file/ {print $2}' /etc/audit/auditd.conf | xargs)")"/* | grep -Pv '^\h*\H+\h+(adm|root)\b')"

   # If all files passed, then we pass
   if [ "$tst" = "pass" ] && [ -z "$output2" ]; then
      {
         echo -e "- PASS:"
         echo -e "- The \"log_group\" parameter is set to: \"$(awk -F= '{print $2}' <<< "$output" | xargs)\" in \"/etc/audit/auditd.conf\""
         echo -e "- Only authorized groups are assigned ownership audit log files"
         echo -e "- End check - Only authorized users own audit log files"
      }
      exit "${XCCDF_RESULT_PASS:-101}"
   else
      # print the reason why we are failing
      echo -e "- FAIL:"
      [ "$tst" != "pass" ] && echo -e "- The \"log_group\" parameter is set to: \"$(awk -F= '{print $2}' <<< "$output" | xargs)\" in \"/etc/audit/auditd.conf\""
      if [ -n "$output2" ]; then
         echo -e "$output2" | while read -r filegrp; do
            echo "- File: \"$(awk '{print $1}' <<< "$filegrp")\" is owned by group: \"$(awk '{print $2}' <<< "$filegrp")\""
         done
      fi
      echo -e "- End check - Only authorized groups assigned ownership audit log files"
      exit "${XCCDF_RESULT_FAIL:-102}"
   fi
}
