/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingEntryCountResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String MATCHING_ENTRY_COUNT_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.37";
    private static final byte TYPE_DEBUG_INFO = -96;
    private static final byte TYPE_SEARCH_INDEXED = -127;
    private static final long serialVersionUID = -5488025806310455564L;
    private final boolean searchIndexed;
    private final int countValue;
    @NotNull
    private final List<String> debugInfo;
    @NotNull
    private final MatchingEntryCountType countType;

    MatchingEntryCountResponseControl() {
        this.searchIndexed = false;
        this.countType = null;
        this.countValue = -1;
        this.debugInfo = null;
    }

    private MatchingEntryCountResponseControl(@NotNull MatchingEntryCountType countType, int countValue, boolean searchIndexed, @Nullable Collection<String> debugInfo) {
        super(MATCHING_ENTRY_COUNT_RESPONSE_OID, false, MatchingEntryCountResponseControl.encodeValue(countType, countValue, searchIndexed, debugInfo));
        this.countType = countType;
        this.countValue = countValue;
        this.searchIndexed = searchIndexed;
        this.debugInfo = debugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(debugInfo));
    }

    public MatchingEntryCountResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.countType = MatchingEntryCountType.valueOf(elements[0].getType());
            if (this.countType == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_INVALID_COUNT_TYPE.get(StaticUtils.toHex(elements[0].getType())));
            }
            switch (this.countType) {
                case EXAMINED_COUNT: 
                case UNEXAMINED_COUNT: {
                    this.countValue = ASN1Integer.decodeAsInteger(elements[0]).intValue();
                    if (this.countValue >= 0) break;
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_NEGATIVE_EXACT_COUNT.get());
                }
                case UPPER_BOUND: {
                    this.countValue = ASN1Integer.decodeAsInteger(elements[0]).intValue();
                    if (this.countValue > 0) break;
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_NON_POSITIVE_UPPER_BOUND.get());
                }
                default: {
                    this.countValue = -1;
                }
            }
            boolean isIndexed = this.countType != MatchingEntryCountType.UNKNOWN;
            List debugMessages = Collections.emptyList();
            block11: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -96: {
                        ASN1Element[] debugElements = ASN1Sequence.decodeAsSequence(elements[i]).elements();
                        debugMessages = new ArrayList(debugElements.length);
                        for (ASN1Element e : debugElements) {
                            debugMessages.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        continue block11;
                    }
                    case -127: {
                        isIndexed = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block11;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_RESPONSE_UNKNOWN_ELEMENT_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.searchIndexed = isIndexed;
            this.debugInfo = Collections.unmodifiableList(debugMessages);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static MatchingEntryCountResponseControl createExactCountResponse(int count, boolean examined, @Nullable Collection<String> debugInfo) {
        return MatchingEntryCountResponseControl.createExactCountResponse(count, examined, true, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createExactCountResponse(int count, boolean examined, boolean searchIndexed, @Nullable Collection<String> debugInfo) {
        Validator.ensureTrue(count >= 0);
        MatchingEntryCountType countType = examined ? MatchingEntryCountType.EXAMINED_COUNT : MatchingEntryCountType.UNEXAMINED_COUNT;
        return new MatchingEntryCountResponseControl(countType, count, searchIndexed, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUpperBoundResponse(int upperBound, @Nullable Collection<String> debugInfo) {
        return MatchingEntryCountResponseControl.createUpperBoundResponse(upperBound, true, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUpperBoundResponse(int upperBound, boolean searchIndexed, @Nullable Collection<String> debugInfo) {
        Validator.ensureTrue(upperBound > 0);
        return new MatchingEntryCountResponseControl(MatchingEntryCountType.UPPER_BOUND, upperBound, searchIndexed, debugInfo);
    }

    @NotNull
    public static MatchingEntryCountResponseControl createUnknownCountResponse(@Nullable Collection<String> debugInfo) {
        return new MatchingEntryCountResponseControl(MatchingEntryCountType.UNKNOWN, -1, false, debugInfo);
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull MatchingEntryCountType countType, int countValue, boolean searchIndexed, @Nullable Collection<String> debugInfo) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        switch (countType) {
            case EXAMINED_COUNT: 
            case UNEXAMINED_COUNT: 
            case UPPER_BOUND: {
                elements.add(new ASN1Integer(countType.getBERType(), countValue));
                break;
            }
            case UNKNOWN: {
                elements.add(new ASN1Null(countType.getBERType()));
            }
        }
        if (debugInfo != null) {
            ArrayList<ASN1OctetString> debugElements = new ArrayList<ASN1OctetString>(debugInfo.size());
            for (String s : debugInfo) {
                debugElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-96, debugElements));
        }
        if (!searchIndexed) {
            elements.add(new ASN1Boolean(-127, searchIndexed));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public MatchingEntryCountType getCountType() {
        return this.countType;
    }

    public int getCountValue() {
        return this.countValue;
    }

    public boolean searchIndexed() {
        return this.searchIndexed;
    }

    @NotNull
    public List<String> getDebugInfo() {
        return this.debugInfo;
    }

    @Override
    @NotNull
    public MatchingEntryCountResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new MatchingEntryCountResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static MatchingEntryCountResponseControl get(@NotNull SearchResult result) throws LDAPException {
        Control c = result.getResponseControl(MATCHING_ENTRY_COUNT_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof MatchingEntryCountResponseControl) {
            return (MatchingEntryCountResponseControl)c;
        }
        return new MatchingEntryCountResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_MATCHING_ENTRY_COUNT_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MatchingEntryCountResponseControl(countType='");
        buffer.append(this.countType.name());
        buffer.append('\'');
        switch (this.countType) {
            case EXAMINED_COUNT: 
            case UNEXAMINED_COUNT: {
                buffer.append(", count=");
                buffer.append(this.countValue);
                break;
            }
            case UPPER_BOUND: {
                buffer.append(", upperBound=");
                buffer.append(this.countValue);
            }
        }
        buffer.append(", searchIndexed=");
        buffer.append(this.searchIndexed);
        if (!this.debugInfo.isEmpty()) {
            buffer.append(", debugInfo={");
            Iterator<String> iterator = this.debugInfo.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

