# Pentesting

Prowler has some checks that analyse pentesting risks (Secrets, Internet Exposed, AuthN, AuthZ and more).

## Detect Secrets

Prowler uses `detect-secrets` library to search for any secrets that are stores in plaintext within your environment.

The actual checks that have this funcionality are:

1. autoscaling_find_secrets_ec2_launch_configuration
- awslambda_function_no_secrets_in_code
- awslambda_function_no_secrets_in_variables
- cloudformation_outputs_find_secrets
- ec2_instance_secrets_user_data
- ecs_task_definitions_no_environment_secrets
- ssm_document_secrets

To execute detect-secrets related checks, you can run the following command:

```console
prowler <provider> --categories secrets
```
## Internet Exposed Resources

Several checks analyse resources that are exposed to the Internet, these are:

1. apigateway_endpoint_public
- appstream_fleet_default_internet_access_disabled
- awslambda_function_not_publicly_accessible
- ec2_ami_public
- ec2_ebs_public_snapshot
- ec2_instance_internet_facing_with_instance_profile
- ec2_instance_public_ip
- ec2_networkacl_allow_ingress_any_port
- ec2_securitygroup_allow_wide_open_public_ipv4
- ec2_securitygroup_allow_ingress_from_internet_to_any_port
- ecr_repositories_not_publicly_accessible
- eks_control_plane_endpoint_access_restricted
- eks_endpoints_not_publicly_accessible
- eks_control_plane_endpoint_access_restricted
- eks_endpoints_not_publicly_accessible
- elbv2_internet_facing
- kms_key_not_publicly_accessible
- opensearch_service_domains_not_publicly_accessible
- rds_instance_no_public_access
- rds_snapshots_public_access
- s3_bucket_policy_public_write_access
- s3_bucket_public_access
- sagemaker_notebook_instance_without_direct_internet_access_configured
- sns_topics_not_publicly_accessible
- sqs_queues_not_publicly_accessible

...

To execute internet-exposed related checks, you can run the following command:

```console
prowler <provider> --categories internet-exposed
```

### Shodan

Prowler allows you check if any elastic ip in your AWS Account is exposed in Shodan with `-N`/`--shodan <shodan_api_key>` option:

```console
prowler aws --shodan <shodan_api_key> -c ec2_elastic_ip_shodan
```
