# Check mapping between Prowler v3 and v2

Prowler v3 comes with different identifiers but we maintained the same checks that were implemented in v2. The reason for this change is because in previows versions of Prowler, check names were mostly based on CIS Benchmark for AWS. In v3 all checks are independent from any security framework and they have its own name and ID.

If you need more information about how new compliance implementation works in Prowler v3 see [Compliance](../../compliance/) section.

```
checks_v3_to_v2_mapping = {
    "accessanalyzer_enabled_without_findings": "extra769",
    "account_maintain_current_contact_details": "check117",
    "account_security_contact_information_is_registered": "check118",
    "account_security_questions_are_registered_in_the_aws_account": "check115",
    "acm_certificates_expiration_check": "extra730",
    "acm_certificates_transparency_logs_enabled": "extra724",
    "apigateway_authorizers_enabled": "extra746",
    "apigateway_client_certificate_enabled": "extra743",
    "apigateway_endpoint_public": "extra745",
    "apigateway_logging_enabled": "extra722",
    "apigateway_waf_acl_attached": "extra744",
    "apigatewayv2_access_logging_enabled": "extra7156",
    "apigatewayv2_authorizers_enabled": "extra7157",
    "appstream_fleet_default_internet_access_disabled": "extra7193",
    "appstream_fleet_maximum_session_duration": "extra7190",
    "appstream_fleet_session_disconnect_timeout": "extra7191",
    "appstream_fleet_session_idle_disconnect_timeout": "extra7192",
    "autoscaling_find_secrets_ec2_launch_configuration": "extra775",
    "awslambda_function_invoke_api_operations_cloudtrail_logging_enabled": "extra720",
    "awslambda_function_no_secrets_in_code": "extra760",
    "awslambda_function_no_secrets_in_variables": "extra759",
    "awslambda_function_not_publicly_accessible": "extra798",
    "awslambda_function_url_cors_policy": "extra7180",
    "awslambda_function_url_public": "extra7179",
    "awslambda_function_using_supported_runtimes": "extra762",
    "cloudformation_stack_outputs_find_secrets": "extra742",
    "cloudformation_stacks_termination_protection_enabled": "extra7154",
    "cloudfront_distributions_field_level_encryption_enabled": "extra767",
    "cloudfront_distributions_geo_restrictions_enabled": "extra732",
    "cloudfront_distributions_https_enabled": "extra738",
    "cloudfront_distributions_logging_enabled": "extra714",
    "cloudfront_distributions_using_deprecated_ssl_protocols": "extra791",
    "cloudfront_distributions_using_waf": "extra773",
    "cloudtrail_cloudwatch_logging_enabled": "check24",
    "cloudtrail_kms_encryption_enabled": "check27",
    "cloudtrail_log_file_validation_enabled": "check22",
    "cloudtrail_logs_s3_bucket_access_logging_enabled": "check26",
    "cloudtrail_logs_s3_bucket_is_not_publicly_accessible": "check23",
    "cloudtrail_multi_region_enabled": "check21",
    "cloudtrail_s3_dataevents_read_enabled": "extra7196",
    "cloudtrail_s3_dataevents_write_enabled": "extra725",
    "cloudwatch_changes_to_network_acls_alarm_configured": "check311",
    "cloudwatch_changes_to_network_gateways_alarm_configured": "check312",
    "cloudwatch_changes_to_network_route_tables_alarm_configured": "check313",
    "cloudwatch_changes_to_vpcs_alarm_configured": "check314",
    "cloudwatch_cross_account_sharing_disabled": "extra7144",
    "cloudwatch_log_group_kms_encryption_enabled": "extra7164",
    "cloudwatch_log_group_retention_policy_specific_days_enabled": "extra7162",
    "cloudwatch_log_metric_filter_and_alarm_for_aws_config_configuration_changes_enabled": "check39",
    "cloudwatch_log_metric_filter_and_alarm_for_cloudtrail_configuration_changes_enabled": "check35",
    "cloudwatch_log_metric_filter_authentication_failures": "check36",
    "cloudwatch_log_metric_filter_aws_organizations_changes": "extra7197",
    "cloudwatch_log_metric_filter_disable_or_scheduled_deletion_of_kms_cmk": "check37",
    "cloudwatch_log_metric_filter_for_s3_bucket_policy_changes": "check38",
    "cloudwatch_log_metric_filter_policy_changes": "check34",
    "cloudwatch_log_metric_filter_root_usage": "check33",
    "cloudwatch_log_metric_filter_security_group_changes": "check310",
    "cloudwatch_log_metric_filter_sign_in_without_mfa": "check32",
    "cloudwatch_log_metric_filter_unauthorized_api_calls": "check31",
    "codeartifact_packages_external_public_publishing_disabled": "extra7195",
    "codebuild_project_older_90_days": "extra7174",
    "codebuild_project_user_controlled_buildspec": "extra7175",
    "config_recorder_all_regions_enabled": "check25",
    "directoryservice_directory_log_forwarding_enabled": "extra7181",
    "directoryservice_directory_monitor_notifications": "extra7182",
    "directoryservice_directory_snapshots_limit": "extra7184",
    "directoryservice_ldap_certificate_expiration": "extra7183",
    "directoryservice_radius_server_security_protocol": "extra7188",
    "directoryservice_supported_mfa_radius_enabled": "extra7189",
    "dynamodb_accelerator_cluster_encryption_enabled": "extra7165",
    "dynamodb_tables_kms_cmk_encryption_enabled": "extra7128",
    "dynamodb_tables_pitr_enabled": "extra7151",
    "ec2_ami_public": "extra76",
    "ec2_ebs_default_encryption": "extra761",
    "ec2_ebs_public_snapshot": "extra72",
    "ec2_ebs_snapshots_encrypted": "extra740",
    "ec2_ebs_volume_encryption": "extra729",
    "ec2_elastic_ip_shodan": "extra7102",
    "ec2_elastic_ip_unassgined": "extra7146",
    "ec2_instance_imdsv2_enabled": "extra786",
    "ec2_instance_internet_facing_with_instance_profile": "extra770",
    "ec2_instance_managed_by_ssm": "extra7124",
    "ec2_instance_older_than_specific_days": "extra758",
    "ec2_instance_profile_attached": "check119",
    "ec2_instance_public_ip": "extra710",
    "ec2_instance_secrets_user_data": "extra741",
    "ec2_networkacl_allow_ingress_any_port": "extra7138",
    "ec2_networkacl_allow_ingress_tcp_port_22": "check45",
    "ec2_networkacl_allow_ingress_tcp_port_3389": "check46",
    "ec2_securitygroup_allow_ingress_from_internet_to_any_port": "extra748",
    "ec2_securitygroup_allow_ingress_from_internet_to_port_mongodb_27017_27018": "extra753",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_ftp_port_20_21": "extra7134",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_22": "check41",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_3389": "check42",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_cassandra_7199_9160_8888": "extra754",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_elasticsearch_kibana_9200_9300_5601": "extra779",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_kafka_9092": "extra7135",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_memcached_11211": "extra755",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_mysql_3306": "extra750",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_oracle_1521_2483": "extra749",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_postgres_5432": "extra751",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_redis_6379": "extra752",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_sql_server_1433_1434": "extra7137",
    "ec2_securitygroup_allow_ingress_from_internet_to_tcp_port_telnet_23": "extra7136",
    "ec2_securitygroup_allow_wide_open_public_ipv4": "extra778",
    "ec2_securitygroup_default_restrict_traffic": "check43",
    "ec2_securitygroup_from_launch_wizard": "extra7173",
    "ec2_securitygroup_not_used": "extra75",
    "ec2_securitygroup_with_many_ingress_egress_rules": "extra777",
    "ecr_repositories_lifecycle_policy_enabled": "extra7194",
    "ecr_repositories_not_publicly_accessible": "extra77",
    "ecr_repositories_scan_images_on_push_enabled": "extra765",
    "ecr_repositories_scan_vulnerabilities_in_latest_image": "extra776",
    "ecs_task_definitions_no_environment_secrets": "extra768",
    "efs_encryption_at_rest_enabled": "extra7161",
    "efs_have_backup_enabled": "extra7148",
    "efs_not_publicly_accessible": "extra7143",
    "eks_cluster_kms_cmk_encryption_in_secrets_enabled": "extra797",
    "eks_control_plane_endpoint_access_restricted": "extra796",
    "eks_control_plane_logging_all_types_enabled": "extra794",
    "eks_endpoints_not_publicly_accessible": "extra795",
    "elb_insecure_ssl_ciphers": "extra792",
    "elb_internet_facing": "extra79",
    "elb_logging_enabled": "extra717",
    "elb_ssl_listeners": "extra793",
    "elbv2_deletion_protection": "extra7150",
    "elbv2_desync_mitigation_mode": "extra7155",
    "elbv2_insecure_ssl_ciphers": "extra792",
    "elbv2_internet_facing": "extra79",
    "elbv2_listeners_underneath": "extra7158",
    "elbv2_logging_enabled": "extra717",
    "elbv2_ssl_listeners": "extra793",
    "elbv2_waf_acl_attached": "extra7129",
    "emr_cluster_account_public_block_enabled": "extra7178",
    "emr_cluster_master_nodes_no_public_ip": "extra7176",
    "emr_cluster_publicly_accesible": "extra7177",
    "glacier_vaults_policy_public_access": "extra7147",
    "glue_data_catalogs_connection_passwords_encryption_enabled": "extra7117",
    "glue_data_catalogs_metadata_encryption_enabled": "extra7116",
    "glue_database_connections_ssl_enabled": "extra7115",
    "glue_development_endpoints_cloudwatch_logs_encryption_enabled": "extra7119",
    "glue_development_endpoints_job_bookmark_encryption_enabled": "extra7121",
    "glue_development_endpoints_s3_encryption_enabled": "extra7114",
    "glue_etl_jobs_amazon_s3_encryption_enabled": "extra7118",
    "glue_etl_jobs_cloudwatch_logs_encryption_enabled": "extra7120",
    "glue_etl_jobs_job_bookmark_encryption_enabled": "extra7122",
    "guardduty_is_enabled": "extra713",
    "guardduty_no_high_severity_findings": "extra7139",
    "iam_administrator_access_with_mfa": "extra71",
    "iam_avoid_root_usage": "check11",
    "iam_check_saml_providers_sts": "extra733",
    "iam_disable_30_days_credentials": "extra774",
    "iam_disable_45_days_credentials": "extra7198",
    "iam_disable_90_days_credentials": "check13",
    "iam_no_custom_policy_permissive_role_assumption": "extra7100",
    "iam_no_expired_server_certificates_stored": "extra7199",
    "iam_no_root_access_key": "check112",
    "iam_password_policy_expires_passwords_within_90_days_or_less": "check111",
    "iam_password_policy_lowercase": "check16",
    "iam_password_policy_minimum_length_14": "check19",
    "iam_password_policy_number": "check18",
    "iam_password_policy_reuse_24": "check110",
    "iam_password_policy_symbol": "check17",
    "iam_password_policy_uppercase": "check15",
    "iam_policy_allows_privilege_escalation": "extra7185",
    "iam_policy_attached_only_to_group_or_roles": "check116",
    "iam_policy_no_administrative_privileges": "check122",
    "iam_root_hardware_mfa_enabled": "check114",
    "iam_root_mfa_enabled": "check113",
    "iam_rotate_access_key_90_days": "check14",
    "iam_support_role_created": "check120",
    "iam_user_hardware_mfa_enabled": "extra7125",
    "iam_user_mfa_enabled_console_access": "check12",
    "iam_user_no_setup_initial_access_key": "check121",
    "iam_user_two_active_access_key": "extra7123",
    "iam_role_cross_service_confused_deputy_prevention": "extra7201",
    "kms_cmk_are_used": "extra7126",
    "kms_cmk_rotation_enabled": "check28",
    "kms_key_not_publicly_accessible": "extra736",
    "macie_is_enabled": "extra712",
    "opensearch_service_domains_audit_logging_enabled": "extra7101",
    "opensearch_service_domains_cloudwatch_logging_enabled": "extra715",
    "opensearch_service_domains_encryption_at_rest_enabled": "extra781",
    "opensearch_service_domains_https_communications_enforced": "extra783",
    "opensearch_service_domains_internal_user_database_enabled": "extra784",
    "opensearch_service_domains_node_to_node_encryption_enabled": "extra782",
    "opensearch_service_domains_not_publicly_accessible": "extra716",
    "opensearch_service_domains_updated_to_the_latest_service_software_version": "extra785",
    "opensearch_service_domains_use_cognito_authentication_for_kibana": "extra780",
    "rds_instance_backup_enabled": "extra739",
    "rds_instance_deletion_protection": "extra7113",
    "rds_instance_enhanced_monitoring_enabled": "extra7132",
    "rds_instance_integration_cloudwatch_logs": "extra747",
    "rds_instance_minor_version_upgrade_enabled": "extra7131",
    "rds_instance_multi_az": "extra7133",
    "rds_instance_no_public_access": "extra78",
    "rds_instance_storage_encrypted": "extra735",
    "rds_snapshots_public_access": "extra723",
    "redshift_cluster_audit_logging": "extra721",
    "redshift_cluster_automated_snapshot": "extra7149",
    "redshift_cluster_automatic_upgrades": "extra7160",
    "redshift_cluster_public_access": "extra711",
    "route53_domains_privacy_protection_enabled": "extra7152",
    "route53_domains_transferlock_enabled": "extra7153",
    "route53_public_hosted_zones_cloudwatch_logging_enabled": "extra719",
    "s3_account_level_public_access_blocks": "extra7186",
    "s3_bucket_acl_prohibited": "extra7172",
    "s3_bucket_default_encryption": "extra734",
    "s3_bucket_no_mfa_delete": "extra7200",
    "s3_bucket_object_versioning": "extra763",
    "s3_bucket_policy_public_write_access": "extra771",
    "s3_bucket_public_access": "extra73",
    "s3_bucket_secure_transport_policy": "extra764",
    "s3_bucket_server_access_logging_enabled": "extra718",
    "sagemaker_models_network_isolation_enabled": "extra7105",
    "sagemaker_models_vpc_settings_configured": "extra7106",
    "sagemaker_notebook_instance_encryption_enabled": "extra7112",
    "sagemaker_notebook_instance_root_access_disabled": "extra7103",
    "sagemaker_notebook_instance_vpc_settings_configured": "extra7104",
    "sagemaker_notebook_instance_without_direct_internet_access_configured": "extra7111",
    "sagemaker_training_jobs_intercontainer_encryption_enabled": "extra7107",
    "sagemaker_training_jobs_network_isolation_enabled": "extra7109",
    "sagemaker_training_jobs_volume_and_output_encryption_enabled": "extra7108",
    "sagemaker_training_jobs_vpc_settings_configured": "extra7110",
    "secretsmanager_automatic_rotation_enabled": "extra7163",
    "securityhub_enabled": "extra799",
    "shield_advanced_protection_in_associated_elastic_ips": "extra7166",
    "shield_advanced_protection_in_classic_load_balancers": "extra7171",
    "shield_advanced_protection_in_cloudfront_distributions": "extra7167",
    "shield_advanced_protection_in_global_accelerators": "extra7169",
    "shield_advanced_protection_in_internet_facing_load_balancers": "extra7170",
    "shield_advanced_protection_in_route53_hosted_zones": "extra7168",
    "sns_topics_kms_encryption_at_rest_enabled": "extra7130",
    "sns_topics_not_publicly_accessible": "extra731",
    "sqs_queues_not_publicly_accessible": "extra727",
    "sqs_queues_server_side_encryption_enabled": "extra728",
    "ssm_document_secrets": "extra7141",
    "ssm_documents_set_as_public": "extra7140",
    "ssm_managed_compliant_patching": "extra7127",
    "trustedadvisor_errors_and_warnings": "extra726",
    "vpc_endpoint_connections_trust_boundaries": "extra789",
    "vpc_endpoint_services_allowed_principals_trust_boundaries": "extra790",
    "vpc_flow_logs_enabled": "check29",
    "vpc_peering_routing_tables_with_least_privilege": "check44",
    "workspaces_volume_encryption_enabled": "extra7187",
}
```
