#!/bin/bash

sudo chown packer:root /var/www/html
rm -fR /var/www/html/*

#Static cert for the labs, generated with:
# sudo openssl req -x509 -nodes -days 3650 \
#   -subj "/C=US/ST=OK/L=Durant/O=RCI/OU=Information Technology/CN=lablocal.lab.local" \
#   -newkey rsa:2048 -keyout /etc/ssl/private/nginx.self.key \
#   -out /etc/ssl/certs/nginx.self.crt

sudo bash -c 'cat << EOF > /etc/ssl/certs/nginx.self.crt
-----BEGIN CERTIFICATE-----
MIID6TCCAtGgAwIBAgIUAuCyXPRy42/7tiYOAl2hx9jomuowDQYJKoZIhvcNAQEL
BQAwgYMxCzAJBgNVBAYTAlVTMQswCQYDVQQIDAJPSzEPMA0GA1UEBwwGRHVyYW50
MRgwFgYDVQQKDA81eDcgRW50ZXJwcmlzZXMxHzAdBgNVBAsMFkluZm9ybWF0aW9u
IFRlY2hub2xvZ3kxGzAZBgNVBAMMEmxhYmxvY2FsLjV4Ny5sb2NhbDAeFw0yMjEx
MjIwMTM0MDBaFw0zMjExMTkwMTM0MDBaMIGDMQswCQYDVQQGEwJVUzELMAkGA1UE
CAwCT0sxDzANBgNVBAcMBkR1cmFudDEYMBYGA1UECgwPNXg3IEVudGVycHJpc2Vz
MR8wHQYDVQQLDBZJbmZvcm1hdGlvbiBUZWNobm9sb2d5MRswGQYDVQQDDBJsYWJs
b2NhbC41eDcubG9jYWwwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDm
Ey8DVHsxPi6JPBGqGmlIifqAvtNE0faxhDzDo0SPLVpgWTU5zYyFf8Pk49s11h4L
/dyoJWv9u1lrxLj2Y8PoThJSo8wITSF8Zb57fmOhufKAym6V4uGk3HwiZcM6sMl9
qLJFcyWakFlkepN1gqBHS6QPbO9/sSTW/9wgptEhSUdVk4p/fjkPJS5izV+GevVs
e2GnaNvXZy4wKOTHf2yu6mvSAnk3MdrBLlGxYa3DXwtooIaZwJBltbc1CQnQriLq
FFK3scNwDcyOLf2k8Jk3lMBCcvjGTx5pGhk0eUDnm3Xmwb8oAgFV8KfAmlOwSDLv
nNx74cOBmfATFl8qFXjxAgMBAAGjUzBRMB0GA1UdDgQWBBR1o8+ulJ4cRttUhT1J
VDU9SK1rtTAfBgNVHSMEGDAWgBR1o8+ulJ4cRttUhT1JVDU9SK1rtTAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQCLBvMgRp3QZcNDbWVrtsGrUhhd
TL9UfMNFsgrgkutTiUnZBMKY1oNK3jiv1kvB2rRdPAx0R+F9/WBbHvdKP0klsZNY
ulPAZWzshs4WSej/qDR0nOYhO4HHGpmo3Shfym2VZRNDLIBApzTdYGCYF4rgm/Bi
2uWuGm7wGkZOUQvG//dcC4GCvUnebjI0d4yLQ5RxOCeElvXT43H0d8diC+Yj6j9R
o0decWxsKGAYN9q25e7TWlVZ1+ESniHyfUXslvIkKX7tp6HtEOq+fODwAT6LG1Ih
qqPDEv/7cZ9kqXfJ89gHvNbfgTsn+MUFKPWizR1E5lK5Tq7ktLBNC4B5sOtp
-----END CERTIFICATE-----
EOF'

sudo bash -c 'cat << EOF > /etc/ssl/private/nginx.self.key
-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDmEy8DVHsxPi6J
PBGqGmlIifqAvtNE0faxhDzDo0SPLVpgWTU5zYyFf8Pk49s11h4L/dyoJWv9u1lr
xLj2Y8PoThJSo8wITSF8Zb57fmOhufKAym6V4uGk3HwiZcM6sMl9qLJFcyWakFlk
epN1gqBHS6QPbO9/sSTW/9wgptEhSUdVk4p/fjkPJS5izV+GevVse2GnaNvXZy4w
KOTHf2yu6mvSAnk3MdrBLlGxYa3DXwtooIaZwJBltbc1CQnQriLqFFK3scNwDcyO
Lf2k8Jk3lMBCcvjGTx5pGhk0eUDnm3Xmwb8oAgFV8KfAmlOwSDLvnNx74cOBmfAT
Fl8qFXjxAgMBAAECggEABnzT/owLTUArn8MJ3HoSLfF2FttKqc4h3q+T5xBbho4I
1l6tmYuqQrlvlKy4KbR39G6cIkGr4eO+icNqU8hMZeiNq7bisfk60H8t992Agbb0
l50dsSxMoJF3DqE/+A+0Hs769+pfTRR08NhkABRG4LvJTIYN2tPr7gQY+PK7Quz4
WlQwElG3PWDEIKK09yV/KPzaDWGrHb0nbT6lMB3ykCaLzwSkaBr6/zhhYjBYkn+b
cbFc9MbDrfLAUkm1HNlgEJSoRbwG8BeGL0Wjbve2u8n9z9lVkHTA3OiXRMcxze9C
D6+glHQyAznTGpQ6wqMC9R+TrMCYdYgoMqSu1BD+AQKBgQD+PT5XOuga+EY7b/+x
uRiowWEQ6AlAmF8XLR1Op9Xzr29DAa1qFFYR2nFfz5xbKHEJfT/lZXcdFeKii3d1
/edB5df01xPNRr4qbNc7U5IEcGJtPa8IWyzVP7NUGLX78/fH50dTGqUuufbtS77l
9XG8tdqvfyocbtgCib+KIxcAuQKBgQDnqxkGCZpVoEo9AV8wUOv0OGZcoO+bVAzq
WcD/k5deqf59YFbNF9x2lnpeIc7qCbo0t7uw+iTQ262kCJhPUDc8unBVydtf+vqJ
6oGa5FPRPsjSNaVEZUWQ91R1rkLpXeG9qM2AiwnrEgYmc9ddQ3VFce1JM4l+VA61
vL/o3x9t+QKBgBKa8MD5cprmqF0ZKSEcZo2S+UN/d43emLbdelOTPLkEkaPZr5Mf
wdy0m69jRhH1t6/2FoL3Fexu+ZLjme5skkvkQhWM18oh7zCznlydFQZ2Iv3TkceO
xI0miD0TQd4aUHu0lSejv4rX2RYsgN/bQmOI+2P0bmR+SBiHdBjr0HchAoGAdwVa
V9W7Kt6tBWadBu+sKc6IGHK+ZyjpccUm+KdVD1d63eMO9VOa+noY6B+qdGcG+Wqj
zSrWm08hiLK5vZXSqyqF6C1Kvabt7MlESNWhklEVT5osDFWTRgUrqUIcMlT/UzdU
TQQh1lluO3csYEf2CfWcGQ2XSAXbgNc2KWfod9ECgYAGe1aOAPc9bOM3phfyg3HC
7cEvcyz2qcu+FoqRmaRu/SQm7zN7fHW8PmaE9CHGprzxAJYYBS9FiEH4JO+jAI9O
lyfmHuqRzxQB5Y+1sTOgIu4ZNDRIrLCxHK0Pc6+7M1xUR60i20fACfNK8ns0Trn5
ZwTEMvOtQDeNh3UHgKOKCQ==
-----END PRIVATE KEY-----
EOF'

#nginx setup
sudo bash -c 'cat << EOF >/etc/nginx/sites-available/default
server {
        listen 10.50.7.50:80 default_server;
        listen 10.50.7.50:443 ssl;
        listen 0.0.0.0:507;
        
        server_name         lablocal.lab.local;
        ssl_certificate     /etc/ssl/certs/nginx.self.crt;
        ssl_certificate_key /etc/ssl/private/nginx.self.key;

        root /var/www/html;
        index index.html;
        server_name _;
        expires -1;
}
EOF'

#made static for labs
# sudo openssl req -x509 -nodes -days 3650 \
#   -subj "/C=US/ST=OK/L=Durant/O=RCI/OU=Information Technology/CN=juiceshop.lab.local" \
#   -newkey rsa:2048 -keyout /etc/ssl/private/js.self.key \
#   -out /etc/ssl/certs/js.self.crt

sudo bash -c 'cat << EOF > /etc/ssl/private/js.self.key
-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC2d6VseWwp0Py6
DInVpJ1ThR/ayHIWJgq9Go4xwieSBpWxRVxl7Gi93O3O0o9gAzWT/gJuG6ZC4Ge1
1CurLubo13lD1sMgN0PeWFEI4SeeH1zD1sWIbC1BwdetZ4ZI2xGxNkSNINRaNmnF
9wsW44VlR0NaACmiiTaA08QD9EcasqHDr6LaWqy1lQBjFckob13NsBb+cn8064qH
/9xIFD9iFDobv9n82EzaKGX/AYqf55sWfyGOzVx0bwsyeCudSLw30rsVXiYq3bKM
VEwXRWWCQeirFRAwU9FJqGpH/VS9czFkU8t+s2K+u4NXWPjwRPQoMBuZ3cZ67dq1
rTqN6kfNAgMBAAECggEARsHi7kuvvA+E0YjnMmfhcm/fSHIOe7RI2cggd/84ZRIU
nmetSwEAJRA1T8yrOKpF7pvDyXsDYE+xJ/uc64cGmChmp/3yMN39fY117yGQwWqc
CH2SoDKC4ksPHflVQ49gLv5CWw/uCQWsws3oCPo10m5uGcqSWqsm7ZIxIu9pW1pe
Kn9JKRv0dL5ilBnu4MZYQX8RpeHdsh3/pdVD5gyW/nwd+jiu82ggyXnHVd3ybBa4
XBjc/zuGdCjjGWt7iPkp1C0CXpfimkuGwBvDgRgM2feUVGdB9yOm/LGXx88aYYxU
uvprN0EnIT6DbF4xcJppsVey1jOCnENwIhpu8dPnqQKBgQDkfIZMbCfQdFIyhDZ+
MEwON7HeEmGpGsBA69mrflOlTRW5QblWOW6nJpqibfs8+rT/ybIG5jj7UBXnnPNb
pkYSav3/Zrw3rNEOkzp8Zrs50e/0/Ft8LagNd5MgQinBJkdq/KNMK8j05ELkGeTN
4uV2zEMaQCVaT2OjCMAXySwp3wKBgQDMcIHiZ0wg2KcKCvzWdKZ+YzX52rmBjE0n
7UoiaRXKV4bEzU5yEutoewRwJNiHH1+64ZwypuHOHe2a6G93vUOL8yk93z5BZJVD
QQSpV6iNTDqExuJzkh30DC3xi8AsdGQkS0qnzR60gLPYfLeew9cYgkAWTb/9SWV3
bFn5447b0wKBgQCjuTs+rc2FyKRRwH2PxKnrEiupFoDWfO3AV4BdK6Nicq8bVaYp
y/OnYLkzpR1/X6KtG2kvGm9AXe2kTsnvJWFWt0YUahh6yKHxELy7AZ4tW2rXoLEp
dUnThJhvaBmlZvmMB0Y4QbO5D4uDCa7zfR+yFcILoGVjpjmeTJnhMW0s/wKBgBwc
zH+JnNpXcIDdCe+jktGGawG0phW+aU24P52Dvc9ZQdsGMGdXWq+/Wtjg+DV8hvl3
1LbSY/KoAuhuVgWtLQCtq1oqvLDZV/0rj6yJtU/Yz6M6hiFGUoAgvKCeiwqR5sNm
5xk0B6jimdiHLejTHVztbEqk3mXCFgXaDHVkaVypAoGAenrHPrRBt+ScNSUbIUNr
JXaZrY7nhp1MSE2SU+ZT2xoUCRpNyhiopD0DnwQoZRzNqGFO0hJhTEegruasOlWD
n5oEg5/7U8NHB0tb+cenHDyIu2urFoWHEBCjePb1ANJ36tWDhZM43IMdcTadQR4+
WB04sMTOaPdt/T0mQwlqcJI=
-----END PRIVATE KEY-----
EOF'

sudo bash -c 'cat << EOF > /etc/ssl/certs/js.self.crt
-----BEGIN CERTIFICATE-----
MIID0TCCArmgAwIBAgIUHZJKcQryyKwu1wgZ4+cRKIwX/HAwDQYJKoZIhvcNAQEL
BQAweDELMAkGA1UEBhMCVVMxCzAJBgNVBAgMAk9LMQ8wDQYDVQQHDAZEdXJhbnQx
DDAKBgNVBAoMA1JDSTEfMB0GA1UECwwWSW5mb3JtYXRpb24gVGVjaG5vbG9neTEc
MBoGA1UEAwwTanVpY2VzaG9wLmxhYi5sb2NhbDAeFw0yNTA0MDEyMDM0MDVaFw0z
NTAzMzAyMDM0MDVaMHgxCzAJBgNVBAYTAlVTMQswCQYDVQQIDAJPSzEPMA0GA1UE
BwwGRHVyYW50MQwwCgYDVQQKDANSQ0kxHzAdBgNVBAsMFkluZm9ybWF0aW9uIFRl
Y2hub2xvZ3kxHDAaBgNVBAMME2p1aWNlc2hvcC5sYWIubG9jYWwwggEiMA0GCSqG
SIb3DQEBAQUAA4IBDwAwggEKAoIBAQC2d6VseWwp0Py6DInVpJ1ThR/ayHIWJgq9
Go4xwieSBpWxRVxl7Gi93O3O0o9gAzWT/gJuG6ZC4Ge11CurLubo13lD1sMgN0Pe
WFEI4SeeH1zD1sWIbC1BwdetZ4ZI2xGxNkSNINRaNmnF9wsW44VlR0NaACmiiTaA
08QD9EcasqHDr6LaWqy1lQBjFckob13NsBb+cn8064qH/9xIFD9iFDobv9n82Eza
KGX/AYqf55sWfyGOzVx0bwsyeCudSLw30rsVXiYq3bKMVEwXRWWCQeirFRAwU9FJ
qGpH/VS9czFkU8t+s2K+u4NXWPjwRPQoMBuZ3cZ67dq1rTqN6kfNAgMBAAGjUzBR
MB0GA1UdDgQWBBSHGJeAtevZjYlIo/HOMrJ3sczxhjAfBgNVHSMEGDAWgBSHGJeA
tevZjYlIo/HOMrJ3sczxhjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBCwUA
A4IBAQAijYsiyM9HvA7rdpelNMgNTewM33PnNbQU5iqetAcBAYCgGZU5GaX66cww
8u7H09Y3Q2YGbhVncCUtvFqtO48EAunV4ytjNzIJHVhOwyNdvTSTmJ7ldDkofB+b
DNKpUOAgpUecb9kOsumVpXcoxgsgdpyupmiVKVf0Ko+2za/R1mSWljmyfXfBGXlT
vCks64JPO3LNNuv5wWChnOCL148OsTojXckaVOddAEHZGGhhIwHo7ZsirfHJjyrC
bILtLtLQc0qOiAaqt6n6LvZPfPfmHgtdCkVEfJTk+PtfqaK9xVCGCJPyuR+A3ieB
/IfqvtdRDp7jetqeVt5Us8PVvDyT
-----END CERTIFICATE-----
EOF'

#Proxy for juice shop kubernetes service, websockets should work
sudo bash -c 'cat << EOF >/etc/nginx/sites-available/juiceshop
server {
  listen 10.50.7.20:80;
  server_name _;
  listen 10.50.7.20:443 ssl;
  server_name         juiceshop.lab.local;
  ssl_certificate     /etc/ssl/certs/js.self.crt;
  ssl_certificate_key /etc/ssl/private/js.self.key;

  location / {
    proxy_pass http://127.0.0.1:30020;
    proxy_set_header Upgrade \$http_upgrade;
    proxy_set_header Connection "Upgrade";
    proxy_set_header Host \$host;
  }
}

EOF'

#Proxy for dvwa kubernetes service
sudo bash -c 'cat << EOF >/etc/nginx/sites-available/dvwa
server {
        listen 10.50.7.24:80;
        server_name _;

        location / {
          proxy_pass http://127.0.0.1:30024;
        }
}
EOF'

#Proxy for bwapp kubernetes service
sudo bash -c 'cat << EOF >/etc/nginx/sites-available/bwapp
server {
        listen 10.50.7.22:80;
        server_name _;

        location / {
          proxy_pass http://127.0.0.1:30022;
        }
}
EOF'

#Proxy for bwapp kubernetes service
sudo bash -c 'cat << EOF >/etc/nginx/sites-available/wackopicko
server {
        listen 10.50.7.23:80;
        server_name _;

        location / {
          proxy_pass http://127.0.0.1:30023;
        }
}
EOF'

#create symlinks to make these sites active
sudo ln -s /etc/nginx/sites-available/juiceshop /etc/nginx/sites-enabled/juiceshop
sudo ln -s /etc/nginx/sites-available/dvwa /etc/nginx/sites-enabled/dvwa
sudo ln -s /etc/nginx/sites-available/bwapp /etc/nginx/sites-enabled/bwapp
sudo ln -s /etc/nginx/sites-available/wackopicko /etc/nginx/sites-enabled/wackopicko

ls -l /etc/nginx/sites-enabled

sudo systemctl restart nginx.service
sudo systemctl --no-pager status nginx.service

echo "Restarting Nessus service after IP changes"
sudo systemctl restart nessusd.service
sudo systemctl --no-pager status nessusd.service
