#!/bin/bash

echo '******************************************************'
echo 'Installing MySql'
echo '******************************************************'

echo "mysql-server mysql-server/root_password password mysqlrootpwd" | sudo debconf-set-selections
echo "mysql-server mysql-server/root_password_again password mysqlrootpwd" | sudo debconf-set-selections
sudo DEBIAN_FRONTEND=noninteractive apt install -y mysql-server mysql-client

echo "CREATE USER 'student'@'localhost' IDENTIFIED BY 'Password1';" | mysql -u root -pmysqlrootpwd
echo "CREATE USER 'student'@'%' IDENTIFIED BY 'Password1';" | mysql -u root -pmysqlrootpwd

echo "CREATE DATABASE IF NOT EXISTS grafana;" | mysql -u root -pmysqlrootpwd
echo "GRANT ALL ON *.* TO 'student'@'localhost';" | mysql -u root -pmysqlrootpwd
echo "GRANT ALL ON *.* TO 'student'@'%';" | mysql -u root -pmysqlrootpwd
echo "flush privileges;" | mysql -u root -pmysqlrootpwd

sudo sed -i "s/^bind-address.*$/bind-address = 0.0.0.0/" /etc/mysql/mysql.conf.d/mysqld.cnf
sudo systemctl restart mysql.service

