#!/bin/bash

echo '******************************************************'
echo 'Beginning kubernetes image configuration'
echo '******************************************************'
echo 'Waiting for microk8s to finish loading before doing operations on it'
sudo microk8s status --wait-ready
sudo microk8s kubectl get nodes

cd /home/student
mkdir k8s

#TODO: Get rid of these download/imports (except NJSScan)
#Change to k8s pull
# wget -q http://jp.car3.co:8000/docker/juiceshop.14.1.1.tar   
# sudo microk8s ctr image import juiceshop.14.1.1.tar   
# rm juiceshop.14.1.1.tar   

# wget -q http://jp.car3.co:8000/docker/dvwa.22.1.tar
# sudo microk8s ctr image import dvwa.22.1.tar
# rm dvwa.22.1.tar

# wget -q http://jp.car3.co:8000/docker/bwapp.22.1.tar
# sudo microk8s ctr image import bwapp.22.1.tar
# rm bwapp.22.1.tar

# wget -q http://jp.car3.co:8000/docker/wackopicko.22.1.tar
# sudo microk8s ctr image import wackopicko.22.1.tar
# rm wackopicko.22.1.tar

echo "Pulling container images"

echo "JuiceShop"
sudo microk8s ctr image pull docker.io/bkimminich/juice-shop:v14.1.1 > juiceshop.txt
tail -30 juiceshop.txt

echo "BWApp"
sudo microk8s ctr image pull docker.io/raesene/bwapp:latest > bwapp.txt
tail -30 bwapp.txt

echo "DVWA"
sudo microk8s ctr image pull docker.io/vulnerables/web-dvwa:latest > dvwa.txt
tail -30 dvwa.txt

echo "WackoPicko"
sudo microk8s ctr image pull docker.io/adamdoupe/wackopicko:latest > wackopicko.txt
tail -30 wackopicko.txt

wget -q http://jp.car3.co:8000/docker/nodejsscan.22.1.tar
docker load -i nodejsscan.22.1.tar
docker image ls
rm nodejsscan.22.1.tar

#JuiceShop v 14.1.1
bash -c 'cat << EOF > /home/student/k8s/juiceshop.yaml
kind: Deployment
apiVersion: apps/v1
metadata:
  name: juice-shop
spec:
  template:
    metadata:
      labels:
        app: juice-shop
    spec:
      containers:
      - name: juice-shop
        image: docker.io/bkimminich/juice-shop:v14.1.1
#        imagePullPolicy: Never
  selector:
    matchLabels:
      app: juice-shop
---
kind: Service
apiVersion: v1
metadata:
  name: juice-shop
spec:
  type: NodePort
  selector:
    app: juice-shop
  ports:
  - name: http
    port: 8000
    targetPort: 3000
    nodePort: 30020
EOF'

sudo microk8s kubectl apply -f /home/student/k8s/juiceshop.yaml

bash -c 'cat << EOF > /home/student/k8s/dvwa.yaml
kind: Deployment
apiVersion: apps/v1
metadata:
  name: dvwa
spec:
  template:
    metadata:
      labels:
        app: dvwa
    spec:
      containers:
      - name: dvwa
        image: docker.io/vulnerables/web-dvwa:latest
#        imagePullPolicy: Never
  selector:
    matchLabels:
      app: dvwa
---
kind: Service
apiVersion: v1
metadata:
  name: dvwa
spec:
  type: NodePort
  selector:
    app: dvwa
  ports:
  - name: http
    port: 8000
    targetPort: 80
    nodePort: 30024
EOF'

sudo microk8s kubectl apply -f /home/student/k8s/dvwa.yaml

bash -c 'cat << EOF > /home/student/k8s/bwapp.yaml
kind: Deployment
apiVersion: apps/v1
metadata:
  name: bwapp
spec:
  template:
    metadata:
      labels:
        app: bwapp
    spec:
      containers:
      - name: bwapp
        image: docker.io/raesene/bwapp:latest
#        imagePullPolicy: Never
  selector:
    matchLabels:
      app: bwapp
---
kind: Service
apiVersion: v1
metadata:
  name: bwapp
spec:
  type: NodePort
  selector:
    app: bwapp
  ports:
  - name: http
    port: 8000
    targetPort: 80
    nodePort: 30022
EOF'

sudo microk8s kubectl apply -f /home/student/k8s/bwapp.yaml

bash -c 'cat << EOF > /home/student/k8s/wackopicko.yaml
kind: Deployment
apiVersion: apps/v1
metadata:
  name: wackopicko
spec:
  template:
    metadata:
      labels:
        app: wackopicko
    spec:
      containers:
      - name: wackopicko
        image: docker.io/adamdoupe/wackopicko:latest
#        imagePullPolicy: Never
  selector:
    matchLabels:
      app: wackopicko
---
kind: Service
apiVersion: v1
metadata:
  name: wackopicko
spec:
  type: NodePort
  selector:
    app: wackopicko
  ports:
  - name: http
    port: 8000
    targetPort: 80
    nodePort: 30023
EOF'

sudo microk8s kubectl apply -f /home/student/k8s/wackopicko.yaml

echo 'microk8s kubectl describe services'
sudo microk8s kubectl describe services

echo 'microk8s kubectl get deployments'
sudo microk8s kubectl get deployments

echo 'microk8s kubectl get pods'
sudo microk8s kubectl get pods

echo 'Sleeping 2 minutes to allow image import to complete'
sleep 120

echo 'microk8s kubectl describe services'
sudo microk8s kubectl describe services

echo 'microk8s kubectl get deployments'
sudo microk8s kubectl get deployments

echo 'microk8s kubectl get pods'
sudo microk8s kubectl get pods

echo 'netstat -antp'
sudo netstat -antp

echo '******************************************************'
echo 'Kubernetes operations complete'
echo '******************************************************'


echo '******************************************************'
echo 'Beginning docker image setup'
echo '******************************************************'

sudo bash -c 'cat << EOF > /etc/systemd/system/dockerNginx.service
[Unit]
Description=nginx demo Docker Container
Requires=docker.service
After=docker.service


[Service]
TimeoutStartSec=0
Restart=always

ExecStartPre=-/usr/bin/docker stop dockerNginx
ExecStartPre=-/usr/bin/docker container rm /dockerNginx
ExecStart=/usr/bin/docker run --name dockerNginx -p 10.50.7.26:80:80 --restart unless-stopped nginxdemos/hello


ExecStop=/usr/bin/docker stop -t 2 dockerNginx

[Install]
WantedBy=default.target
EOF'

sudo systemctl daemon-reload
sudo systemctl enable dockerNginx.service
sudo systemctl start dockerNginx.service

echo '******************************************************'
echo 'Docker image setup completed'
echo '******************************************************'
