#!/bin/bash

echo '******************************************************'
echo 'Beginning kubernetes install'
echo '******************************************************'

sudo snap install microk8s --classic
sudo usermod -a -G microk8s student
sudo chown -f -R student /home/student/.kube
sudo usermod -a -G microk8s packer
sudo chown -f -R packer /home/packer/.kube

curl -LO "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/linux/amd64/kubectl"
sudo install -o root -g root -m 0755 kubectl /usr/local/bin/kubectl
kubectl version --client

echo '******************************************************'
echo 'Kubernetes operations complete'
echo '******************************************************'
