#!/bin/bash
cd /home/student/packer 

echo '******************************************************'
echo 'Installing Grafana'
echo '******************************************************'

wget -q http://jp.car3.co:8000/packages/grafana_9.5.2_amd64.deb -O grafana.deb
sudo dpkg -i grafana.deb

#Set the default timezone for users
sudo sed -i "s/;default_timezone = .*/default_timezone = UTC/" /etc/grafana/grafana.ini
#Setup the Graphite data source
sudo cp /home/student/packer/graphite.yaml /etc/grafana/provisioning/datasources/graphite.yaml
sudo cp /home/student/packer/mysql.yaml /etc/grafana/provisioning/datasources/mysql.yaml
sudo cp /home/student/packer/postgresql.yaml /etc/grafana/provisioning/datasources/postgresql.yaml

sudo systemctl daemon-reload
sudo systemctl start grafana-server
sudo systemctl enable grafana-server
echo "Checking Grafana Version (should be 9.5.2)"
grafana-cli -v 

sudo netstat -antp

echo '******************************************************'
echo 'Installing Graphite'
echo '******************************************************'
sudo DEBIAN_FRONTEND=noninteractive apt install -y graphite-carbon gunicorn

# from: https://luppeng.wordpress.com/2024/09/01/install-and-setup-graphite-on-ubuntu-server-24-04-via-apt-repository/
sudo cp /home/student/packer/routers.py /usr/lib/python3/dist-packages/carbon/routers.py
sudo systemctl restart carbon-cache.service
sudo systemctl status carbon-cache.service


sudo DEBIAN_FRONTEND=noninteractive apt remove -y python3-blinker
sudo pip3 install graphite-api --break-system-packages





sudo systemctl enable graphite-api.service
sudo systemctl enable graphite-api.socket
sudo systemctl start graphite-api.service
sudo systemctl --no-pager status graphite-api.service

# echo "Testing Graphite API"
# curl localhost:8542/metrics?query=*

# echo "Setting PSQL pasword"
# sudo -u postgres psql -c "alter user postgres with password 'pass';"

