#!/bin/bash

echo '******************************************************'
echo 'Installing aws cli'
echo '******************************************************'
# echo Double-removing old version...

# sudo DEBIAN_FRONTEND=noninteractive apt remove -y awscli
# pip uninstall -y awscli

wget -q https://awscli.amazonaws.com/awscli-exe-linux-x86_64.zip -O "awscliv2.zip"
unzip awscliv2.zip
sudo ./aws/install
which aws
/usr/local/bin/aws --version

echo '******************************************************'
echo 'Installing azure cli'
echo '******************************************************'
curl -sL https://aka.ms/InstallAzureCLIDeb | sudo bash

echo '******************************************************'
echo 'Installing gcloud cli'
echo '******************************************************'
#Use one of the two following methods:

#APT
# curl https://packages.cloud.google.com/apt/doc/apt-key.gpg | sudo apt-key --keyring /usr/share/keyrings/cloud.google.gpg add -
# echo "deb [signed-by=/usr/share/keyrings/cloud.google.gpg] https://packages.cloud.google.com/apt cloud-sdk main" | sudo tee -a /etc/apt/sources.list.d/google-cloud-sdk.list
# sudo apt-get update && sudo apt-get install google-cloud-cli

#Manual
# wget -q http://jp.car3.co:8000/packages/google-cloud-cli-432.0.0-linux-x86_64.tar.gz
# tar zxf google-cloud-cli-432.0.0-linux-x86_64.tar.gz
# cd google-cloud-sdk 
# bash install.sh --quiet

echo '******************************************************'
echo 'Installing CFN_Nag'
echo '******************************************************'
sudo gem install -q cfn-nag

echo '******************************************************'
echo 'Installing Prowler - newest version'
echo '******************************************************'
cd /home/student
#pipx install prowler==3.10.0
pipx install prowler
pipx ensurepath

echo '******************************************************'
echo 'Installing cloud custodian'
echo '******************************************************'
python3 -m venv custodian
source custodian/bin/activate
pip install c7n
custodian version
deactivate

# No longer used
# echo '******************************************************'
# echo 'installing ElectricEye'
# echo '******************************************************'
# cd /home/student
# git clone https://github.com/jonrau1/ElectricEye.git
# cd /home/student/ElectricEye
# pip3 install -r requirements.txt