#!/bin/bash

echo '******************************************************'
echo 'Final VM setup scripts'
echo '******************************************************'

echo '******************************************************'
echo 'Provisioning root bash aliases'
echo '******************************************************'
sudo cp ../files/bash_alias_root /root/.bash_aliases
sudo chown root:root /root/.bash_aliases

echo '******************************************************'
echo 'Copying tripwire/nginx files to ~student'
echo '******************************************************'
cp ../files/tw* /home/student

echo '******************************************************'
echo 'Provisioning student .profile'
echo '******************************************************'
cp ../files/studentProfile /home/student/.profile
cat /home/student/.profile



echo '******************************************************'
echo 'Making final network settings'
echo '******************************************************'
sudo bash -c "echo '127.0.0.1 fleet.lab.internal' >> /etc/hosts"
sudo bash -c "echo '127.0.0.1 ubuntu.lab.internal' >> /etc/hosts"
sudo bash -c "echo '127.0.0.1 ubuntu' >> /etc/hosts"

ping -c2 fleet.lab.internal
ping -c2 ubuntu

echo '******************************************************'
echo 'Adding additional users for labs/CTF'
echo '******************************************************'
sudo bash -c 'cat << EOF >>/etc/passwd
tsmith:x:1002:1002::/home/tsmith:/bin/bash
noaccess:x:0000:0::/home/noaccess:/bin/bash
clay:x:1004:1001::/home/clay:/bin/bash
thillman:x:1005:1001::/home/thillman:/bin/bash
dhoelzer:x:1006:1001::/home/dhoelzer:/bin/bash
EOF'
sudo cat /etc/passwd

sudo bash -c 'cat << EOF >>/etc/shadow
tsmith:\$6\$lFRr4XfN\$5jVD2DcWReiGmY.EK2r6x11hxX7SctPGMLt16P8BkbKC7U3rLEVfM8jgnDsDkhxUAlDqg/F/8zJTa5acbPgB9/:17946:0:99999:7:::
noaccess:\$6\$wbSMA41w\$IURuilIC1Vr1r2iwpX73V0P.4yh630/ceTGEUHwHXuGuSymgCjKgB7OIRSDTKgyQeQLosIvXAqW5U9IfHFtCR.:17956:0:99999:7:::
clay:\$6\$P6v/7gQl\$6fHgE/grTOtThtU3Owjk9UtYrCHuRcAbmMhnaCE12Rs6tE13/TeeMg6ZN2vxSkn7LrwTk2lZoNIfgzMhf1Qat1:17946:0:99999:7:::
thillman:\$6\$8rDsXC4p\$ikS2MDkJ/slKtjtBasDb1d38lw1tEwD4Y./q/6PJJOvPnQwxQJ4QaChAL4i1775i20j8plY588OzYtD5djNxJ/:17946:0:99999:7:::
dhoelzer:\$6\$uNgRoTQw\$ZvHuPiMhvyPOPRFdKwleK1daHe1ghh2s6VK1eWAArY2JC7SaPP84darzCFBnivKT4sQ5KFdNTeV1wtAwCRBr.0:17946:0:99999:7:::
EOF'
sudo cat /etc/shadow

echo '******************************************************'
echo 'Running scripts'
echo '******************************************************'

echo '******************************************************'
echo 'nginx.sh'
echo '******************************************************'
bash ./nginx.sh

echo '******************************************************'
echo 'k8sImageSetup.sh'
echo '******************************************************'
bash ./k8sImageSetup.sh

echo '******************************************************'
echo 'gitSetup.sh'
echo '******************************************************'
bash ./gitSetup.sh

echo '******************************************************'
echo 'CISO Assistant: ca.sh'
echo 'Requires interaction to setup user'
echo '******************************************************'
bash ./ca.sh

