#!/bin/bash

##nmap from Ubuntu is a bit old, so install it from a .deb instead
echo '******************************************************'
echo "Installing Nmap"
echo '******************************************************'

wget -q http://ch.car3.co:8000/packages/nmap_7.95-4_amd64.deb -O nmap.deb
sudo dpkg -i nmap.deb 
nmap -V

echo '******************************************************'
echo "Installing pwsh"
echo '******************************************************'
wget -q https://github.com/PowerShell/PowerShell/releases/download/v7.4.11/powershell_7.4.11-1.deb_amd64.deb -O powershell.deb
sudo dpkg -i powershell.deb
pwsh -c '$psversiontable'

echo '******************************************************'
echo "Installing Pester pwsh module"
echo '******************************************************'
pwsh -c "Install-Module -Name Pester -Force -SkipPublisherCheck"
pwsh -c "Get-Module -Name Pester -ListAvailable"

echo '******************************************************'
echo "Installing yandiff"
echo '******************************************************'
#pre-requistes for Yandiff
sudo cpanm ExtUtils::MakeMaker
sudo cpanm XML::Twig
sudo cpanm Nmap::Parser
sudo install /home/student/packer/yandiff /usr/local/bin
# sudo mv /home/student/packer/yandiff /usr/local/bin
# sudo chmod a+x /usr/local/bin/yandiff
/usr/local/bin/yandiff --help

echo '******************************************************'
echo 'Installing inspec'
echo '******************************************************'
cd /home/student
#Download and install new inspec version
wget -q https://packages.chef.io/repos/apt/stable/ubuntu/18.04/inspec_5.22.72-1_amd64.deb -O inspec.deb
sudo dpkg -i inspec.deb

#TODO: Does this correctly accept inspec license?
inspec nothing --chef-license=accept
inspec version
inspec nothing

echo '******************************************************'
echo 'Installing TerraScan'
echo '******************************************************'

wget -q https://github.com/tenable/terrascan/releases/download/v1.19.9/terrascan_1.19.9_Linux_x86_64.tar.gz -O terrascan.tgz
tar zxvf terrascan.tgz
sudo install terrascan /usr/local/bin
