#!/bin/bash
echo '******************************************************'
echo 'Installing Grafana'
echo '******************************************************'

wget -q http://ch.car3.co:8000/cs/ubuntu/files/grafana.deb -O grafana.deb
wget -q http://ch.car3.co:8000/cs/ubuntu/files/graphite.yaml
wget -q http://ch.car3.co:8000/cs/ubuntu/files/mysql.yaml
wget -q http://ch.car3.co:8000/cs/ubuntu/files/postgresql.yaml
sudo dpkg -i grafana.deb

#Set the default timezone for users
sudo sed -i "s/;default_timezone = .*/default_timezone = UTC/" /etc/grafana/grafana.ini
#Setup the Graphite data source
sudo cp graphite.yaml /etc/grafana/provisioning/datasources/graphite.yaml
sudo cp mysql.yaml /etc/grafana/provisioning/datasources/mysql.yaml
sudo cp postgresql.yaml /etc/grafana/provisioning/datasources/postgresql.yaml

sudo systemctl daemon-reload
sudo systemctl start grafana-server
sudo systemctl enable grafana-server
echo "Checking Grafana Version (should be 12.1.1)"
grafana-cli -v 

sudo netstat -antp | grep grafana
