

#Install CISO Assistant
# sudo openssl req -x509 -nodes -days 3650 \
#    -subj "/C=US/ST=OK/L=Durant/O=RCI/OU=Information Technology/CN=ubuntu.lab.internal" \
#    -newkey rsa:2048 -keyout /etc/ssl/private/ca.self.key \
#    -out /etc/ssl/certs/ca.self.crt

#clone the repo
git clone https://github.com/intuitem/ciso-assistant-community.git


#go to the config generator
cd ciso-assistant-community/config

#Copy the cert files
mkdir cert

#cert
cat << EOF >>cert/ca.self.crt
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
EOF

cat << EOF >>cert/ca.self.key
-----BEGIN PRIVATE KEY-----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-----END PRIVATE KEY-----
EOF

cat << EOF >>compose.yml
services:
  backend:
    container_name: backend
    image: ghcr.io/intuitem/ciso-assistant-community/backend:latest
    pull_policy: always
    restart: always
    environment:
      - ALLOWED_HOSTS=backend,localhost,ubuntu.lab.internal
      - CISO_ASSISTANT_URL=https://ubuntu.lab.internal:4443
      - DJANGO_DEBUG=True
      - AUTH_TOKEN_TTL=7200
    volumes:
      - ./db:/code/db
    healthcheck:
      test: ["CMD-SHELL", "curl -f http://backend:8000/api/build || exit 1"]
      interval: 10s
      timeout: 5s
      retries: 20
      start_period: 100s
  huey:
    container_name: huey
    image: ghcr.io/intuitem/ciso-assistant-community/backend:latest
    pull_policy: always
    depends_on:
      backend:
        condition: service_healthy
    restart: always
    environment:
      - ALLOWED_HOSTS=backend,localhost
      - CISO_ASSISTANT_URL=https://ubuntu.lab.internal:4443
      - DJANGO_DEBUG=False
      - AUTH_TOKEN_TTL=7200
    volumes:
      - ./db:/code/db
    entrypoint:
      - /bin/sh
      - -c
      - |
        poetry run python manage.py run_huey -w 2 --scheduler-interval 60
  frontend:
    container_name: frontend
    environment:
      - PUBLIC_BACKEND_API_URL=http://backend:8000/api
      - PUBLIC_BACKEND_API_EXPOSED_URL=https://ubuntu.lab.internal:4443/api
      - PROTOCOL_HEADER=x-forwarded-proto
      - HOST_HEADER=x-forwarded-host
    image: ghcr.io/intuitem/ciso-assistant-community/frontend:latest
    pull_policy: always
    depends_on:
      backend:
        condition: service_healthy
  caddy:
    container_name: caddy
    image: caddy:2.10.0
    environment:
      - CISO_ASSISTANT_URL=https://ubuntu.lab.internal:4443
    depends_on:
      backend:
        condition: service_healthy
    restart: unless-stopped
    ports:
      - 4443:4443
    volumes:
      - ./caddy_data:/data
      - ./cert:/data/cert
    command: |
      sh -c 'echo $$CISO_ASSISTANT_URL "{
      reverse_proxy /api/* backend:8000
      reverse_proxy /* frontend:3000
      tls /data/cert/ca.self.crt /data/cert/ca.self.key
      }" > Caddyfile && caddy run'
EOF
# # setting up the python project and dependencies 
# python3 -m venv .venv
# source .venv/bin/activate
# pip install -r requirements.txt

# # run the interactive config generator
# python make_config.py

# ./docker-compose.sh

# deactivate

docker compose up -d

echo "Waiting for CISO Assistant backend to be ready..."
until docker compose exec -T backend curl -f http://localhost:8000/api/build >/dev/null 2>&1; do
  echo "Backend is not ready - waiting 10s..."
  sleep 10
done

echo -e "Backend is ready!"
echo "Creating superuser..."
docker compose exec backend poetry run python manage.py createsuperuser